/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.AsyncSocketServer;
import com.syntaxphoenix.syntaxapi.net.http.Answer;
import com.syntaxphoenix.syntaxapi.net.http.ContentType;
import com.syntaxphoenix.syntaxapi.net.http.HttpWriter;
import com.syntaxphoenix.syntaxapi.net.http.ReceivedRequest;
import com.syntaxphoenix.syntaxapi.net.http.RequestGate;
import com.syntaxphoenix.syntaxapi.net.http.RequestHandler;
import com.syntaxphoenix.syntaxapi.net.http.RequestSerializer;
import com.syntaxphoenix.syntaxapi.net.http.RequestState;
import com.syntaxphoenix.syntaxapi.net.http.RequestType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public class HttpServer
extends AsyncSocketServer {
    private RequestGate gate;
    private RequestHandler handler;
    private RequestSerializer serializer;

    public HttpServer() {
    }

    public HttpServer(ThreadFactory factory) {
        super(factory);
    }

    public HttpServer(ExecutorService service) {
        super(service);
    }

    public HttpServer(ThreadFactory factory, ExecutorService service) {
        super(factory, service);
    }

    public HttpServer(int port) {
        super(port);
    }

    public HttpServer(int port, ThreadFactory factory) {
        super(port, factory);
    }

    public HttpServer(int port, ExecutorService service) {
        super(port, service);
    }

    public HttpServer(int port, ThreadFactory factory, ExecutorService service) {
        super(port, factory, service);
    }

    public HttpServer(int port, InetAddress address) {
        super(port, address);
    }

    public HttpServer(int port, InetAddress address, ThreadFactory factory) {
        super(port, address, factory);
    }

    public HttpServer(int port, InetAddress address, ExecutorService service) {
        super(port, address, service);
    }

    public HttpServer(int port, InetAddress address, ThreadFactory factory, ExecutorService service) {
        super(port, address, factory, service);
    }

    public void setHandler(RequestHandler handler) {
        this.handler = handler;
    }

    public RequestHandler getHandler() {
        return this.handler;
    }

    public void setGate(RequestGate gate) {
        this.gate = gate;
    }

    public RequestGate getGate() {
        return this.gate;
    }

    public void setSerializer(RequestSerializer serializer) {
        this.serializer = serializer;
    }

    public RequestSerializer getSerializer() {
        return this.serializer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void handleClientAsync(Socket socket) throws Throwable {
        ReceivedRequest request;
        BufferedReader reader;
        HttpWriter writer;
        block16: {
            block15: {
                writer = new HttpWriter(new PrintStream(socket.getOutputStream()));
                if (this.serializer == null) {
                    Answer.SERVER_ERROR.respond("error", "No message serializer was registered, Sorry!").write(writer).clearResponse();
                    writer.close();
                    socket.close();
                    throw new IllegalStateException("Serializer can't be null!");
                }
                if (this.handler == null) {
                    Answer.SERVER_ERROR.respond("error", "No message handler was registered, Sorry!").write(writer).clearResponse();
                    writer.close();
                    socket.close();
                    throw new IllegalStateException("Handler can't be null!");
                }
                reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String line = reader.readLine();
                if (line == null) {
                    Answer.NO_CONTENT.write(writer);
                    socket.close();
                    return;
                }
                String[] info = line.split(" ");
                request = new ReceivedRequest(RequestType.fromString(info[0]), info[1].replaceFirst("/", "").split("/"));
                while ((line = reader.readLine()) != null) {
                    request.parseHeader(line);
                    if (!line.isEmpty()) continue;
                }
                if (this.gate == null) break block15;
                RequestState state = this.gate.acceptRequest(writer, request);
                if (state.accepted()) {
                    if (request.hasHeader("expect") && ((String)request.getHeader("expect")).contains("100-continue")) {
                        Answer.CONTINUE.write(writer);
                    }
                    break block16;
                } else {
                    if (!state.message()) {
                        new Answer(ContentType.JSON).code(400).respond("error", "method or contenttype is not supported").write(writer);
                    }
                    reader.close();
                    writer.close();
                    socket.close();
                    return;
                }
            }
            if (request.hasHeader("expect") && ((String)request.getHeader("expect")).contains("100-continue")) {
                Answer.CONTINUE.write(writer);
            }
        }
        if (!request.hasHeader("Content-Length")) {
            new Answer(ContentType.JSON).code(411).respond("error", "no content length given").write(writer);
            reader.close();
            writer.close();
            socket.close();
            return;
        }
        int length = ((Number)request.getHeader("Content-Length")).intValue();
        StringBuilder builder = new StringBuilder();
        if (length != 0) {
            if (length <= 1024) {
                char[] buffer = new char[length];
                reader.read(buffer, 0, length);
                builder.append(buffer);
            } else {
                char[] buffer = new char[1024];
                while (reader.read(buffer, 0, buffer.length) != -1) {
                    builder.append(buffer);
                }
            }
        }
        request.setData(this.serializer.serialize(builder.toString()));
        if (this.handler.handleRequest(socket, writer, request)) {
            reader.close();
            writer.close();
            socket.close();
        }
    }
}

