/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.net.http.RequestType;
import com.syntaxphoenix.syntaxapi.utils.json.ValueIdentifier;
import java.util.HashMap;
import java.util.Iterator;

public class ReceivedRequest {
    private final HashMap<String, Object> headers = new HashMap();
    private final RequestType type;
    private final String[] path;
    private JsonObject data = new JsonObject();

    public ReceivedRequest(RequestType type, String ... path) {
        this.type = type;
        this.path = path;
    }

    public final ReceivedRequest parseHeaders(Iterable<String> headers) {
        return this.parseHeaders(headers.iterator());
    }

    public final ReceivedRequest parseHeaders(Iterator<String> headers) {
        while (headers.hasNext()) {
            this.parseHeader(headers.next());
        }
        return this;
    }

    public final ReceivedRequest parseHeaders(String ... headers) {
        if (headers == null || headers.length == 0) {
            return this;
        }
        for (String header : headers) {
            this.parseHeader(header);
        }
        return this;
    }

    public final ReceivedRequest parseHeader(String header) {
        if (!header.contains(":")) {
            return this;
        }
        String[] parts = header.split(":", 2);
        this.headers.put(parts[0].toLowerCase(), ValueIdentifier.identify((String)parts[1].trim()));
        return this;
    }

    public final HashMap<String, Object> getHeaders() {
        return this.headers;
    }

    public final Object getHeader(String key) {
        return this.headers.get(key.toLowerCase());
    }

    public final boolean hasHeader(String key) {
        return this.headers.containsKey(key.toLowerCase());
    }

    public final ReceivedRequest setData(JsonObject data) {
        this.data = data;
        return this;
    }

    public final RequestType getType() {
        return this.type;
    }

    public final JsonObject getData() {
        return this.data;
    }

    public final String[] getPath() {
        return this.path;
    }
}

