/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.http.Cookie;
import com.syntaxphoenix.syntaxapi.net.http.HttpWriter;
import com.syntaxphoenix.syntaxapi.net.http.NamedType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Answer<E> {
    public static final List<String> BLOCKED = Arrays.asList("Content-Type", "Server", "Date", "Content-Length", "Set-Cookie");
    protected final HashMap<String, String> headers = new HashMap();
    protected final ArrayList<Cookie> cookies = new ArrayList();
    protected final NamedType type;
    protected int code = 404;

    public Answer(NamedType type) {
        this.type = type;
    }

    public String header(String key) {
        return this.headers.get(key);
    }

    public NamedType type() {
        return this.type;
    }

    public int code() {
        return this.code;
    }

    public Answer<E> code(int code) {
        this.code = code;
        return this;
    }

    public Answer<E> header(String key, Object value) {
        return this.header(key, value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer<E> header(String key, String value) {
        HashMap<String, String> hashMap = this.headers;
        synchronized (hashMap) {
            if (value != null) {
                this.headers.put(key, value);
            } else {
                this.headers.remove(key);
            }
        }
        return this;
    }

    public Answer<E> addCookie(String key, Object value) {
        return this.addCookie(Cookie.of(key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer<E> addCookie(Cookie cookie) {
        ArrayList<Cookie> arrayList = this.cookies;
        synchronized (arrayList) {
            if (!this.cookies.contains(cookie)) {
                this.cookies.add(cookie);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer<E> removeCookie(Cookie cookie) {
        ArrayList<Cookie> arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.remove(cookie);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer<E> removeCookie(String key) {
        ArrayList<Cookie> arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.stream().filter(cookie -> cookie.getName().equals(key)).findFirst().ifPresent(cookie -> this.cookies.remove(cookie));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer<E> clearHeaders() {
        HashMap<String, String> hashMap = this.headers;
        synchronized (hashMap) {
            this.headers.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer<E> clearCookies() {
        ArrayList<Cookie> arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.clear();
        }
        return this;
    }

    public abstract boolean hasResponse();

    public abstract E getResponse();

    public abstract Answer<E> clearResponse();

    public abstract byte[] serializeResponse();

    protected byte[] serializeString(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer<E> write(HttpWriter writer) throws IOException {
        Cookie[] cookie;
        Set<Map.Entry<String, String>> headers;
        if (this.type == null) {
            return this;
        }
        byte[] data = null;
        int length = 0;
        if (this.hasResponse()) {
            data = this.serializeResponse();
            length = data.length;
        }
        writer.write(this.code).writeServer().writeDate().writeLength(length);
        HashMap<String, String> hashMap = this.headers;
        synchronized (hashMap) {
            headers = this.headers.entrySet();
        }
        for (Map.Entry arrayList : headers) {
            if (BLOCKED.contains(arrayList.getKey())) continue;
            writer.write(arrayList);
        }
        ArrayList<Cookie> arrayList = this.cookies;
        synchronized (arrayList) {
            cookie = this.cookies.toArray(new Cookie[0]);
        }
        writer.writeCookies(cookie).writeType(this.type.type());
        writer.line();
        if (data != null) {
            writer.write(data);
        }
        writer.clear();
        return this;
    }
}

