/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.http.ContentDeserializer;
import com.syntaxphoenix.syntaxapi.net.http.ContentSerializer;
import com.syntaxphoenix.syntaxapi.net.http.ContentToUrlModifier;
import com.syntaxphoenix.syntaxapi.net.http.NamedType;
import com.syntaxphoenix.syntaxapi.net.http.RequestData;
import java.net.URL;

public interface ContentType
extends NamedType {
    public ContentSerializer serializer();

    public ContentDeserializer deserializer();

    public ContentToUrlModifier urlModifier();

    default public boolean supportsUrlModification() {
        return this.urlModifier() != null;
    }

    default public void modifyUrl(URL url, RequestData<?> object) {
        ContentToUrlModifier modifier = this.urlModifier();
        if (modifier != null) {
            modifier.apply(url, object, this.serializer());
        }
    }

    default public String serialize(RequestData<?> object) {
        ContentSerializer serializer = this.serializer();
        if (serializer == null) {
            return "";
        }
        return serializer.process(object);
    }

    default public RequestData<?> deserialize(String value) {
        ContentDeserializer deserializer = this.deserializer();
        if (deserializer == null) {
            return null;
        }
        return deserializer.process(value);
    }

    public static ContentType build(final String type) {
        return new ContentType(){

            @Override
            public String type() {
                return type;
            }

            @Override
            public ContentDeserializer deserializer() {
                return null;
            }

            @Override
            public ContentSerializer serializer() {
                return null;
            }

            @Override
            public ContentToUrlModifier urlModifier() {
                return null;
            }
        };
    }

    public static ContentType build(final String type, final ContentType content) {
        return new ContentType(){

            @Override
            public String type() {
                return type;
            }

            @Override
            public ContentDeserializer deserializer() {
                return content.deserializer();
            }

            @Override
            public ContentSerializer serializer() {
                return content.serializer();
            }

            @Override
            public ContentToUrlModifier urlModifier() {
                return content.urlModifier();
            }
        };
    }

    public static ContentType build(final String type, final ContentSerializer serializer, final ContentDeserializer deserializer) {
        return new ContentType(){

            @Override
            public String type() {
                return type;
            }

            @Override
            public ContentDeserializer deserializer() {
                return deserializer;
            }

            @Override
            public ContentSerializer serializer() {
                return serializer;
            }

            @Override
            public ContentToUrlModifier urlModifier() {
                return null;
            }
        };
    }

    public static ContentType build(final String type, final ContentSerializer serializer, final ContentDeserializer deserializer, final ContentToUrlModifier modifier) {
        return new ContentType(){

            @Override
            public String type() {
                return type;
            }

            @Override
            public ContentDeserializer deserializer() {
                return deserializer;
            }

            @Override
            public ContentSerializer serializer() {
                return serializer;
            }

            @Override
            public ContentToUrlModifier urlModifier() {
                return modifier;
            }
        };
    }
}

