/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.http.RequestData;
import com.syntaxphoenix.syntaxapi.net.http.RequestType;
import com.syntaxphoenix.syntaxapi.utils.json.ValueIdentifier;
import com.syntaxphoenix.syntaxapi.utils.net.SimpleConversion;
import java.util.HashMap;
import java.util.Iterator;

public class ReceivedRequest {
    protected final HashMap<String, Object> headers = new HashMap();
    protected final HashMap<String, Object> cookies = new HashMap();
    protected final HashMap<String, Object> parameters = new HashMap();
    protected final RequestType type;
    protected final String[] path;
    protected final String fullPath;
    private RequestData<?> data;

    public ReceivedRequest(RequestType type, String[] path) {
        this.type = type;
        this.path = path;
        this.fullPath = SimpleConversion.toPath(path);
    }

    ReceivedRequest(RequestType type, String fullPath) {
        this.type = type;
        this.path = SimpleConversion.fromPath(fullPath);
        this.fullPath = fullPath;
    }

    public final ReceivedRequest parseParameters(String ... parameters) {
        for (int index = 0; index < parameters.length; ++index) {
            this.parseParameter(parameters[index].trim());
        }
        return this;
    }

    public final ReceivedRequest parseParameter(String parameter) {
        if (!parameter.contains("=")) {
            return this;
        }
        String[] array = parameter.split("=", 2);
        this.parameters.put(array[0], ValueIdentifier.identify((String)array[1]));
        return this;
    }

    public final HashMap<String, Object> getParams() {
        return this.parameters;
    }

    public final Object getParam(String key) {
        return this.parameters.get(key);
    }

    public final boolean hasParam(String key) {
        return this.parameters.containsKey(key);
    }

    public final ReceivedRequest parseCookies(String cookies) {
        if (!cookies.contains(";")) {
            return this.parseCookie(cookies);
        }
        String[] array = cookies.split(";");
        for (int index = 0; index < array.length; ++index) {
            this.parseCookie(array[index].trim());
        }
        return this;
    }

    public final ReceivedRequest parseCookie(String cookie) {
        if (!cookie.contains("=")) {
            return this;
        }
        String[] array = cookie.split("=");
        this.cookies.put(array[0], ValueIdentifier.identify((String)array[1]));
        return this;
    }

    public final HashMap<String, Object> getCookies() {
        return this.cookies;
    }

    public final Object getCookie(String key) {
        return this.cookies.get(key);
    }

    public final boolean hasCookie(String key) {
        return this.cookies.containsKey(key);
    }

    public final ReceivedRequest parseHeaders(Iterable<String> headers) {
        return this.parseHeaders(headers.iterator());
    }

    public final ReceivedRequest parseHeaders(Iterator<String> headers) {
        while (headers.hasNext()) {
            this.parseHeader(headers.next());
        }
        return this;
    }

    public final ReceivedRequest parseHeaders(String ... headers) {
        if (headers == null || headers.length == 0) {
            return this;
        }
        for (String header : headers) {
            this.parseHeader(header);
        }
        return this;
    }

    public final ReceivedRequest parseHeader(String header) {
        String[] parts;
        if (!header.contains(":")) {
            return this;
        }
        (parts = header.split((String)":", (int)2))[0] = parts[0].toLowerCase();
        if ((parts = header.split((String)":", (int)2))[0].equalsIgnoreCase("Cookie")) {
            return this.parseCookies(parts[1]);
        }
        this.headers.put(parts[0].toLowerCase(), ValueIdentifier.identify((String)parts[1].trim()));
        return this;
    }

    public final HashMap<String, Object> getHeaders() {
        return this.headers;
    }

    public final Object getHeader(String key) {
        return this.headers.get(key.toLowerCase());
    }

    public final boolean hasHeader(String key) {
        return this.headers.containsKey(key.toLowerCase());
    }

    public final ReceivedRequest setData(RequestData<?> data) {
        this.data = data;
        return this;
    }

    public final RequestData<?> getData() {
        return this.data;
    }

    public final RequestType getType() {
        return this.type;
    }

    public final String[] getPath() {
        return this.path;
    }

    public final String getPathAsString() {
        return this.fullPath;
    }
}

