/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.http.HttpSender;
import com.syntaxphoenix.syntaxapi.net.http.HttpWriter;
import com.syntaxphoenix.syntaxapi.net.http.NamedAnswer;
import com.syntaxphoenix.syntaxapi.net.http.PathHandler;
import com.syntaxphoenix.syntaxapi.net.http.ReceivedRequest;
import com.syntaxphoenix.syntaxapi.net.http.RequestHandler;
import com.syntaxphoenix.syntaxapi.net.http.StandardNamedType;
import com.syntaxphoenix.syntaxapi.utils.java.Arrays;
import com.syntaxphoenix.syntaxapi.utils.net.SimpleConversion;
import java.util.HashMap;
import java.util.Objects;

public class RedirectRequestHandler
implements RequestHandler,
PathHandler {
    private final HashMap<String, PathHandler> paths = new HashMap();
    private PathHandler main;

    @Override
    public boolean handleRequest(HttpSender sender, HttpWriter writer, ReceivedRequest data) throws Exception {
        this.redirectPath(sender, writer, data);
        return true;
    }

    @Override
    public void handlePath(HttpSender sender, HttpWriter writer, ReceivedRequest data) throws Exception {
        if (data.getPath().length == 1) {
            if (this.main == null) {
                new NamedAnswer(StandardNamedType.PLAIN).setResponse("Not Found").code(404).write(writer);
                return;
            }
            this.main.handlePath(sender, writer, data);
            return;
        }
        this.redirectPath(sender, writer, new PathedReceivedRequest(data));
    }

    public RedirectRequestHandler setDefault(PathHandler handler) {
        this.main = handler;
        return this;
    }

    public RedirectRequestHandler set(String path, PathHandler handler) {
        Objects.requireNonNull(path, "Path cannot be null!");
        if (handler == null) {
            this.paths.remove(path);
            return this;
        }
        this.paths.put(path, handler);
        return this;
    }

    public RedirectRequestHandler set(PathHandler handler, String ... path) {
        return this.set(this.path(path), handler);
    }

    public RedirectRequestHandler delete(String ... path) {
        return this.set(this.path(path), null);
    }

    public PathHandler getDefault() {
        return this.main;
    }

    public PathHandler get(String ... path) {
        return this.paths.get(this.path(path));
    }

    protected String path(String ... path) {
        return Objects.requireNonNull(path, "Path cannot be null!").length == 1 ? path[0] : SimpleConversion.toPath(path);
    }

    protected void redirectPath(HttpSender sender, HttpWriter writer, ReceivedRequest data) throws Exception {
        PathHandler handler = this.paths.get(data.getPathAsString());
        if (handler == null) {
            if (this.main == null) {
                new NamedAnswer(StandardNamedType.PLAIN).setResponse("Not Found").code(404).write(writer);
                return;
            }
            this.main.handlePath(sender, writer, data);
            return;
        }
        handler.handlePath(sender, writer, data);
    }

    public static class PathedReceivedRequest
    extends ReceivedRequest {
        public PathedReceivedRequest(ReceivedRequest request) {
            this((String[])Arrays.subArray(String[]::new, (Object[])request.getPath(), (int)1), request);
        }

        public PathedReceivedRequest(String path, ReceivedRequest request) {
            super(request.getType(), path);
            this.getHeaders().putAll(request.getHeaders());
            this.setData(request.getData());
        }

        public PathedReceivedRequest(String[] path, ReceivedRequest request) {
            super(request.getType(), path);
            this.getHeaders().putAll(request.getHeaders());
            this.setData(request.getData());
        }
    }
}

