/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.net.http.CustomRequestData;
import com.syntaxphoenix.syntaxapi.net.http.HttpSender;
import com.syntaxphoenix.syntaxapi.net.http.HttpServer;
import com.syntaxphoenix.syntaxapi.net.http.HttpWriter;
import com.syntaxphoenix.syntaxapi.net.http.NamedAnswer;
import com.syntaxphoenix.syntaxapi.net.http.ReceivedRequest;
import com.syntaxphoenix.syntaxapi.net.http.RequestExecution;
import com.syntaxphoenix.syntaxapi.net.http.RequestHandler;
import com.syntaxphoenix.syntaxapi.net.http.RequestSerializer;
import com.syntaxphoenix.syntaxapi.net.http.RequestValidator;
import com.syntaxphoenix.syntaxapi.net.http.StandardNamedType;
import com.syntaxphoenix.syntaxapi.utils.json.JsonTools;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public class RestApiServer
extends HttpServer {
    protected RequestHandler handler;
    protected RequestSerializer serializer;

    public RestApiServer() {
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(ThreadFactory factory) {
        super(factory);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(ExecutorService service) {
        super(service);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(ThreadFactory factory, ExecutorService service) {
        super(factory, service);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port) {
        super(port);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port, ThreadFactory factory) {
        super(port, factory);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port, ExecutorService service) {
        super(port, service);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port, ThreadFactory factory, ExecutorService service) {
        super(port, factory, service);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port, InetAddress address) {
        super(port, address);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port, InetAddress address, ThreadFactory factory) {
        super(port, address, factory);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port, InetAddress address, ExecutorService service) {
        super(port, address, service);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RestApiServer(int port, InetAddress address, ThreadFactory factory, ExecutorService service) {
        super(port, address, factory, service);
        this.setValidator(RequestValidator.DEFAULT_VALIDATOR);
    }

    public RequestHandler getHandler() {
        return this.handler;
    }

    public RequestSerializer getSerializer() {
        return this.serializer;
    }

    public void setHandler(RequestHandler handler) {
        this.handler = handler;
    }

    public void setSerializer(RequestSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    protected RequestExecution handleHttpRequest(HttpSender sender, HttpWriter writer, ReceivedRequest request) throws Exception {
        if (this.serializer == null) {
            this.serializer = value -> JsonTools.readJson((String)value);
        }
        if (this.handler == null) {
            new NamedAnswer(StandardNamedType.PLAIN).setResponse("No message handler was registered, Sorry!").code(500).write(writer);
            return RequestExecution.error(new IllegalStateException("Handler can't be null!"));
        }
        request.setData(new CustomRequestData<JsonObject>(JsonObject.class, this.serializer.serialize(request.getData().getValue().toString())));
        try {
            return RequestExecution.of(this.handler.handleRequest(sender, writer, request));
        }
        catch (Exception e) {
            new NamedAnswer(StandardNamedType.PLAIN).setResponse("Something went wrong handling your request!").code(500).write(writer);
            throw e;
        }
    }
}

