/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.net.http.JsonContentSerializer;
import java.util.Map;

public class SpecialSerializers {
    public static final JsonContentSerializer PLAIN = new JsonContentSerializer(){
        private final char[] CHARS = new char[]{':', ' ', '\t', '\n', '-'};
        private final String NULL = "null";
        private final String NEXT = "==>";

        @Override
        public String process(JsonObject parameters) {
            StringBuilder builder = new StringBuilder();
            this.append(builder, parameters, 0);
            return builder.toString();
        }

        private boolean append(StringBuilder builder, JsonObject object, int depth) {
            for (Map.Entry entry : object.entrySet()) {
                JsonElement element = (JsonElement)entry.getValue();
                for (int current = 0; current < depth; ++current) {
                    builder.append(this.CHARS[2]);
                }
                builder.append((String)entry.getKey());
                builder.append(this.CHARS[0]);
                builder.append(this.CHARS[1]);
                if (element == null || element.isJsonNull()) {
                    builder.append("null");
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    builder.append(element.getAsString());
                    continue;
                }
                builder.append(this.CHARS[3]);
                if (element.isJsonArray()) {
                    this.append(builder, element.getAsJsonArray(), depth + 1);
                    continue;
                }
                this.append(builder, element.getAsJsonObject(), depth + 1);
            }
            return true;
        }

        private boolean append(StringBuilder builder, JsonArray array, int depth) {
            for (JsonElement element : array) {
                for (int current = 0; current < depth; ++current) {
                    builder.append(this.CHARS[2]);
                }
                builder.append(this.CHARS[4]);
                builder.append(this.CHARS[0]);
                if (element == null || element.isJsonNull()) {
                    builder.append("null");
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    builder.append(element.getAsString());
                    continue;
                }
                builder.append("==>");
                builder.append(this.CHARS[3]);
                if (element.isJsonArray()) {
                    this.append(builder, element.getAsJsonArray(), depth + 1);
                    continue;
                }
                this.append(builder, element.getAsJsonObject(), depth + 1);
            }
            return true;
        }
    };
}

