/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.http.ContentDeserializer;
import com.syntaxphoenix.syntaxapi.net.http.ContentSerializer;
import com.syntaxphoenix.syntaxapi.net.http.ContentToUrlModifier;
import com.syntaxphoenix.syntaxapi.net.http.ContentType;
import com.syntaxphoenix.syntaxapi.net.http.DefaultDeserializers;
import com.syntaxphoenix.syntaxapi.net.http.DefaultSerializers;
import com.syntaxphoenix.syntaxapi.net.http.SpecialSerializers;

public enum StandardContentType implements ContentType
{
    URL_ENCODED("application/x-www-form-urlencoded", DefaultSerializers.URL_ENCODED, DefaultDeserializers.URL_ENCODED, ContentToUrlModifier.URL_ENCODED),
    PLAIN_SPECIAL("text/plain", SpecialSerializers.PLAIN, null),
    JSON("application/json", DefaultSerializers.JSON, DefaultDeserializers.JSON);

    private final String type;
    private final ContentSerializer serializer;
    private final ContentDeserializer deserializer;
    private final ContentToUrlModifier urlModifier;

    private StandardContentType(String type, ContentSerializer serializer, ContentDeserializer deserializer, ContentToUrlModifier urlModifier) {
        this.type = type;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.urlModifier = urlModifier;
    }

    private StandardContentType(String type, ContentSerializer serializer, ContentDeserializer deserializer) {
        this.type = type;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.urlModifier = null;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ContentSerializer serializer() {
        return this.serializer;
    }

    @Override
    public ContentDeserializer deserializer() {
        return this.deserializer;
    }

    @Override
    public ContentToUrlModifier urlModifier() {
        return this.urlModifier;
    }

    public static StandardContentType fromString(String value) {
        for (StandardContentType type : StandardContentType.values()) {
            if (!type.type().equals(value)) continue;
            return type;
        }
        return null;
    }
}

