/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net;

import com.syntaxphoenix.syntaxapi.exception.NotImplementedException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public abstract class SocketServer {
    public static final int DEFAULT_PORT = 80;
    private final ExecutorService serverThread;
    private final InetAddress address;
    private final int port;
    private ServerSocket serverSocket;

    public SocketServer() {
        this(80);
    }

    public SocketServer(ThreadFactory factory) {
        this(80, factory);
    }

    public SocketServer(int port) {
        this(port, null, null);
    }

    public SocketServer(int port, ThreadFactory factory) {
        this(port, null, factory);
    }

    public SocketServer(int port, InetAddress address) {
        this(port, address, null);
    }

    public SocketServer(int port, InetAddress address, ThreadFactory factory) {
        this.port = port;
        this.address = address;
        this.serverThread = factory == null ? Executors.newSingleThreadExecutor() : Executors.newSingleThreadExecutor(factory);
    }

    public final void applyName(String name) {
        this.serverThread.submit(() -> Thread.currentThread().setName(name));
    }

    public final ExecutorService getServerThread() {
        return this.serverThread;
    }

    public final int getPort() {
        return this.port;
    }

    public final ServerSocket getSocket() {
        return this.serverSocket;
    }

    public void start() throws IOException {
        if (this.serverSocket != null) {
            return;
        }
        this.serverSocket = this.address == null ? new ServerSocket(this.port) : new ServerSocket(this.port, 50, this.address);
        this.serverThread.submit(() -> {
            try {
                this.handleServer();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        });
    }

    public void stop() throws IOException {
        if (this.serverSocket == null) {
            return;
        }
        this.serverSocket.close();
        this.serverSocket = null;
    }

    public boolean isStarted() {
        return this.serverSocket != null;
    }

    protected void handleException(Throwable throwable) {
        throwable.printStackTrace();
    }

    protected void handleServer() {
        while (this.serverSocket != null) {
            Socket clientSocket = null;
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            if (clientSocket == null) continue;
            boolean open = true;
            try {
                this.handleClient(clientSocket);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
                open = false;
            }
            if (open) continue;
            try {
                clientSocket.close();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
    }

    protected void handleClient(Socket socket) throws Throwable {
        throw new NotImplementedException();
    }
}

