/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.AsyncSocketServer;
import com.syntaxphoenix.syntaxapi.net.http.CustomRequestData;
import com.syntaxphoenix.syntaxapi.net.http.HttpSender;
import com.syntaxphoenix.syntaxapi.net.http.HttpWriter;
import com.syntaxphoenix.syntaxapi.net.http.NamedAnswer;
import com.syntaxphoenix.syntaxapi.net.http.ReceivedRequest;
import com.syntaxphoenix.syntaxapi.net.http.RequestContent;
import com.syntaxphoenix.syntaxapi.net.http.RequestExecution;
import com.syntaxphoenix.syntaxapi.net.http.RequestGate;
import com.syntaxphoenix.syntaxapi.net.http.RequestSerializer;
import com.syntaxphoenix.syntaxapi.net.http.RequestState;
import com.syntaxphoenix.syntaxapi.net.http.RequestType;
import com.syntaxphoenix.syntaxapi.net.http.RequestValidator;
import com.syntaxphoenix.syntaxapi.net.http.StandardNamedType;
import com.syntaxphoenix.syntaxapi.utils.java.Exceptions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public abstract class HttpServer
extends AsyncSocketServer {
    protected final HashSet<RequestType> supported = new HashSet();
    protected RequestGate gate;
    protected RequestValidator validator;
    protected RequestSerializer serializer;

    public HttpServer() {
    }

    public HttpServer(ThreadFactory factory) {
        super(factory);
    }

    public HttpServer(ExecutorService service) {
        super(service);
    }

    public HttpServer(ThreadFactory factory, ExecutorService service) {
        super(factory, service);
    }

    public HttpServer(int port) {
        super(port);
    }

    public HttpServer(int port, ThreadFactory factory) {
        super(port, factory);
    }

    public HttpServer(int port, ExecutorService service) {
        super(port, service);
    }

    public HttpServer(int port, ThreadFactory factory, ExecutorService service) {
        super(port, factory, service);
    }

    public HttpServer(int port, InetAddress address) {
        super(port, address);
    }

    public HttpServer(int port, InetAddress address, ThreadFactory factory) {
        super(port, address, factory);
    }

    public HttpServer(int port, InetAddress address, ExecutorService service) {
        super(port, address, service);
    }

    public HttpServer(int port, InetAddress address, ThreadFactory factory, ExecutorService service) {
        super(port, address, factory, service);
    }

    public RequestGate getGate() {
        return this.gate;
    }

    public RequestValidator getValidator() {
        return this.validator;
    }

    public RequestSerializer getSerializer() {
        return this.serializer;
    }

    public HttpServer setGate(RequestGate gate) {
        this.gate = gate;
        return this;
    }

    public HttpServer setValidator(RequestValidator validator) {
        this.validator = validator;
        return this;
    }

    public void setSerializer(RequestSerializer serializer) {
        this.serializer = serializer;
    }

    public HttpServer addType(RequestType type) {
        this.supported.add(type);
        return this;
    }

    public HttpServer addTypes(RequestType ... types) {
        for (int index = 0; index < types.length; ++index) {
            this.supported.add(types[index]);
        }
        return this;
    }

    public HttpServer removeType(RequestType type) {
        this.supported.remove((Object)type);
        return this;
    }

    public HttpServer removeTypes(RequestType ... types) {
        for (int index = 0; index < types.length; ++index) {
            this.supported.remove((Object)types[index]);
        }
        return this;
    }

    public HttpServer clearTypes() {
        this.supported.clear();
        return this;
    }

    public RequestType[] getTypes() {
        return this.supported.toArray(new RequestType[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handleClientAsync(Socket socket) throws Throwable {
        ReceivedRequest request;
        BufferedReader reader;
        HttpWriter writer;
        block25: {
            block24: {
                writer = new HttpWriter(new PrintStream(socket.getOutputStream()));
                InputStream stream = socket.getInputStream();
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                String line = reader.readLine();
                if (line == null) {
                    new NamedAnswer(StandardNamedType.PLAIN).code(204).write(writer);
                    socket.close();
                    return;
                }
                String[] info = line.split(" ");
                String[] path = info[1].startsWith("/") ? info[1].substring(1).split("/") : info[1].split("/");
                String[] parameters = null;
                if (path[path.length - 1].contains("?")) {
                    String[] stringArray;
                    parameters = path[path.length - 1].split("\\?");
                    path[path.length - 1] = parameters[0];
                    if (parameters[1].contains("&")) {
                        stringArray = parameters[1].split("&");
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = parameters[1];
                    }
                    parameters = stringArray;
                }
                request = new ReceivedRequest(RequestType.fromString(info[0]), path);
                if (parameters != null) {
                    request.parseParameters(parameters);
                }
                while ((line = reader.readLine()) != null && !line.isEmpty()) {
                    request.parseHeader(line);
                }
                if (!this.supported.isEmpty() && !this.supported.contains((Object)request.getType())) {
                    new NamedAnswer(StandardNamedType.PLAIN).setResponse("Unsupported request method!").code(400).write(writer);
                    reader.close();
                    writer.close();
                    socket.close();
                    return;
                }
                if (this.gate == null) break block24;
                RequestState state = this.gate.acceptRequest(writer, request);
                if (state.accepted()) {
                    if (request.hasHeader("expect") && ((String)request.getHeader("expect")).contains("100-continue")) {
                        new NamedAnswer(StandardNamedType.PLAIN).code(100).write(writer);
                    }
                    break block25;
                } else {
                    if (!state.message()) {
                        new NamedAnswer(StandardNamedType.PLAIN).setResponse("Method or contenttype is not supported").code(400).write(writer);
                    }
                    reader.close();
                    writer.close();
                    socket.close();
                    return;
                }
            }
            if (request.hasHeader("expect") && ((String)request.getHeader("expect")).contains("100-continue")) {
                new NamedAnswer(StandardNamedType.PLAIN).setResponse("No content length given!").code(411).write(writer);
            }
        }
        RequestContent content = RequestContent.UNNEEDED;
        if (this.validator != null) {
            content = this.validator.parseContent(writer, request);
        }
        if (!content.ignore()) {
            if (content.message()) {
                new NamedAnswer(StandardNamedType.PLAIN).setResponse("No content length given!").code(411).write(writer);
                reader.close();
                writer.close();
                socket.close();
                return;
            }
            int length = ((Number)request.getHeader("Content-Length")).intValue();
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < length; ++index) {
                builder.append((char)reader.read());
            }
            String data = builder.toString();
            if (this.serializer != null) {
                try {
                    request.setData(this.serializer.serialize(data));
                }
                catch (Exception exp) {
                    System.out.println(Exceptions.stackTraceToString((Throwable)exp));
                    new NamedAnswer(StandardNamedType.PLAIN).setResponse("Failed to serialize data").code(500).write(writer);
                    reader.close();
                    writer.close();
                    socket.close();
                    return;
                }
            } else {
                request.setData(new CustomRequestData<String>(String.class, data));
            }
        }
        RequestExecution execution = null;
        try {
            execution = this.handleHttpRequest(new HttpSender(socket, reader), writer, request);
        }
        catch (Exception e) {
            execution = RequestExecution.error(e);
        }
        if ((execution == null ? RequestExecution.CLOSE : execution).close()) {
            reader.close();
            writer.close();
            socket.close();
            if (execution.hasThrowable()) {
                throw execution.getThrowable();
            }
        }
    }

    protected RequestExecution handleHttpRequest(HttpSender sender, HttpWriter writer, ReceivedRequest request) throws Exception {
        return RequestExecution.CLOSE;
    }
}

