/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.syntaxphoenix.syntaxapi.net.http.ContentType;
import com.syntaxphoenix.syntaxapi.net.http.Cookie;
import com.syntaxphoenix.syntaxapi.net.http.ResponseCode;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class HttpWriter {
    private final PrintStream output;

    public HttpWriter(PrintStream output) {
        this.output = output;
    }

    public PrintStream getStream() {
        return this.output;
    }

    public HttpWriter write(int code) {
        this.getStream().println("HTTP/1.1 " + code + ' ' + ResponseCode.getName(code));
        return this;
    }

    public HttpWriter writeServer() {
        return this.write("Server", "Java SyntaxPhoenix HTTP Server from Lauriichan : 1.0");
    }

    public HttpWriter writeDate() {
        return this.write("Date", new Date());
    }

    public HttpWriter writeLength(int length) {
        return this.write("Content-Length", length);
    }

    public HttpWriter writeType(ContentType type) {
        return this.writeType(type.type());
    }

    public HttpWriter writeType(String type) {
        return this.write("Content-Type", type + "; charset=UTF-8");
    }

    public HttpWriter writeCookies(Cookie ... cookies) {
        for (int index = 0; index < cookies.length; ++index) {
            this.writeCookie(cookies[index]);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpWriter writeCookie(Cookie cookie) {
        StringBuilder builder = new StringBuilder();
        builder.append(cookie.getName());
        builder.append('=');
        builder.append(cookie.getValue());
        HashMap<String, Object> properties = cookie.getProperties();
        if (!properties.isEmpty()) {
            HashMap<String, Object> hashMap = properties;
            synchronized (hashMap) {
                builder.append("; ");
                builder.append(properties.entrySet().stream().map(entry -> entry.getValue() == null ? (String)entry.getKey() : (String)entry.getKey() + '=' + entry.getValue()).collect(Collectors.joining("; ")));
            }
        }
        return this.write("Set-Cookie", builder.toString());
    }

    public <T> HttpWriter write(Map.Entry<String, T> entry) {
        return this.write(entry.getKey(), entry.getValue());
    }

    public HttpWriter write(String key, Object value) {
        return this.write(key, value.toString());
    }

    public HttpWriter write(String key, String value) {
        this.getStream().println(key + ": " + value);
        return this;
    }

    public HttpWriter write(byte[] buffer) throws IOException {
        this.getStream().write(buffer);
        return this;
    }

    public HttpWriter line() {
        this.getStream().println();
        return this;
    }

    public HttpWriter clear() {
        this.getStream().flush();
        return this;
    }

    public HttpWriter close() {
        this.getStream().close();
        return this;
    }
}

