/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.net.http.Answer;
import com.syntaxphoenix.syntaxapi.net.http.ContentType;

public class JsonAnswer
extends Answer<JsonObject> {
    private JsonObject object = new JsonObject();

    public JsonAnswer(ContentType type) {
        super(type);
    }

    public JsonElement respond(String key) {
        return this.object.get(key);
    }

    public JsonAnswer code(int code) {
        super.code(code);
        return this;
    }

    public JsonAnswer header(String key, Object value) {
        super.header(key, value);
        return this;
    }

    public JsonAnswer header(String key, String value) {
        super.header(key, value);
        return this;
    }

    public JsonAnswer respond(String key, String value) {
        if (value != null) {
            this.object.addProperty(key, value);
        } else {
            this.object.remove(key);
        }
        return this;
    }

    public JsonAnswer respond(String key, JsonElement element) {
        if (element != null) {
            this.object.add(key, element);
        } else {
            this.object.remove(key);
        }
        return this;
    }

    public JsonAnswer respond(JsonObject object) {
        this.object = object;
        return this;
    }

    public JsonAnswer clearHeaders() {
        this.clearHeaders();
        return this;
    }

    public JsonAnswer clearResponse() {
        this.object = new JsonObject();
        return this;
    }

    @Override
    public boolean hasResponse() {
        return !this.object.keySet().isEmpty();
    }

    @Override
    public JsonObject getResponse() {
        return this.object;
    }

    @Override
    public byte[] serializeResponse() {
        return this.serializeString(this.object.toString());
    }
}

