/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.net.http.ContentType;
import com.syntaxphoenix.syntaxapi.net.http.CustomRequestData;
import com.syntaxphoenix.syntaxapi.net.http.RequestType;
import com.syntaxphoenix.syntaxapi.net.http.Response;
import com.syntaxphoenix.syntaxapi.utils.java.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private final HashMap<String, String> headers = new HashMap();
    private final RequestType request;
    private JsonObject parameters = new JsonObject();
    private boolean modifyUrl = false;

    public Request(RequestType request) {
        this.request = request;
    }

    public Request modifyUrl(boolean modifyUrl) {
        this.modifyUrl = modifyUrl;
        return this;
    }

    public Request header(String key, String value) {
        if (value != null) {
            this.headers.put(key, value);
        } else {
            this.headers.remove(key);
        }
        return this;
    }

    public Request parameter(String key, String value) {
        if (value != null) {
            this.parameters.addProperty(key, value);
        } else {
            this.parameters.remove(key);
        }
        return this;
    }

    public Request parameter(String key, JsonElement element) {
        if (element != null) {
            this.parameters.add(key, element);
        } else {
            this.parameters.remove(key);
        }
        return this;
    }

    public Request parameter(JsonObject object) {
        this.parameters = object;
        return this;
    }

    public Request clearHeader() {
        this.headers.clear();
        return this;
    }

    public Request clearParameters() {
        this.parameters = new JsonObject();
        return this;
    }

    public boolean doesModifyUrl() {
        return this.modifyUrl;
    }

    public boolean hasParameters() {
        return !this.parameters.keySet().isEmpty();
    }

    public Response run(String url) throws IOException {
        return this.execute(url, null);
    }

    public Response run(URL url) throws IOException {
        return this.execute(url, null);
    }

    public Response execute(String url, ContentType content) throws IOException {
        return this.execute(new URL(url), content);
    }

    public Response execute(URL url, ContentType content) throws IOException {
        byte[] data = null;
        int length = 0;
        if (this.hasParameters() && this.request.hasOutput()) {
            CustomRequestData<JsonObject> requestData = new CustomRequestData<JsonObject>(JsonObject.class, this.parameters);
            if (!this.modifyUrl) {
                data = content.serialize(requestData).getBytes(StandardCharsets.UTF_8);
                length = data.length;
            } else if (content.supportsUrlModification()) {
                content.modifyUrl(url, requestData);
            }
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(this.request.name());
        connection.setDoOutput(true);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        if (this.request.hasOutput()) {
            connection.setRequestProperty("Content-Type", content.type() + "; charset=UTF-8");
            connection.setFixedLengthStreamingMode(length);
        }
        connection.connect();
        if (data != null && this.request.hasOutput()) {
            OutputStream output = connection.getOutputStream();
            output.write(data);
            output.flush();
            output.close();
        }
        InputStream stream = null;
        try {
            stream = connection.getInputStream();
            if (stream == null) {
                stream = connection.getErrorStream();
            }
        }
        catch (IOException ignore) {
            stream = connection.getErrorStream();
        }
        byte[] response = new byte[]{};
        if (stream != null) {
            response = Streams.toByteArray((InputStream)stream);
        }
        return new Response(connection.getResponseCode(), response, connection.getHeaderFields());
    }
}

