/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syntaxphoenix.syntaxapi.utils.java.Streams;
import com.syntaxphoenix.syntaxapi.utils.json.JsonTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class Response {
    private final JsonObject headers;
    private final int responseCode;
    private final byte[] response;

    public Response(int responseCode, byte[] response, Map<String, List<String>> headerMap) {
        this.responseCode = responseCode;
        this.response = response;
        this.headers = (JsonObject)headerMap.entrySet().stream().collect(JsonTools.toJsonObject());
    }

    public boolean has(String header) {
        return this.headers.has(header.toLowerCase());
    }

    public boolean hasMultiple(String header) {
        if (!this.has(header)) {
            return false;
        }
        return this.get(header).isJsonArray();
    }

    public JsonElement get(String header) {
        return this.headers.get(header);
    }

    public JsonArray getMultiple(String header) {
        return this.headers.get(header).getAsJsonArray();
    }

    public String getAsString(String header) {
        return this.get(header).getAsString();
    }

    public int getCode() {
        return this.responseCode;
    }

    public byte[] getResponseBytes() {
        return this.response;
    }

    public String getResponse() {
        try {
            return Streams.toString((InputStream)new ByteArrayInputStream(this.response));
        }
        catch (IOException e) {
            return new String(this.response);
        }
    }

    public JsonObject getResponseAsJson() {
        return JsonTools.readJson((String)this.getResponse());
    }

    public JsonObject getResponseHeaders() {
        return this.headers;
    }
}

