/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.net.http.web;

import com.syntaxphoenix.syntaxapi.net.http.HttpSender;
import com.syntaxphoenix.syntaxapi.net.http.HttpWriter;
import com.syntaxphoenix.syntaxapi.net.http.NamedAnswer;
import com.syntaxphoenix.syntaxapi.net.http.ReceivedRequest;
import com.syntaxphoenix.syntaxapi.net.http.SimpleFileAnswer;
import com.syntaxphoenix.syntaxapi.net.http.StandardNamedType;
import com.syntaxphoenix.syntaxapi.net.http.web.IWebPathHandler;
import java.io.File;

public class WebPathHandler
implements IWebPathHandler {
    @Override
    public void handlePath(File directory, HttpSender sender, HttpWriter writer, ReceivedRequest data) throws Exception {
        File file = new File(directory, data.getPathAsString());
        if (!file.exists()) {
            new NamedAnswer(StandardNamedType.PLAIN).code(404).write(writer);
            return;
        }
        if (!file.isFile()) {
            if (!(file = new File(file, "index.html")).exists()) {
                new NamedAnswer(StandardNamedType.PLAIN).code(404).write(writer);
                return;
            }
            new SimpleFileAnswer(file, StandardNamedType.HTML).code(200).write(writer);
            return;
        }
        StandardNamedType type = StandardNamedType.parse(data.getPath()[data.getPath().length - 1]);
        if (type == null) {
            new NamedAnswer(StandardNamedType.PLAIN).code(404).write(writer);
            return;
        }
        new SimpleFileAnswer(file, type).code(200).write(writer);
    }
}

