/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.http;

import com.talanlabs.gitlab.api.models.GitlabAccessLevel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class Query {
    private final List<Tuple<String, Tuple<String, String>>> params = new ArrayList<Tuple<String, Tuple<String, String>>>();

    public static final Query newQuery() {
        return new Query();
    }

    private Query() {
    }

    public Query append(String name, String value) throws UnsupportedEncodingException {
        this.params.add(new Tuple<String, Tuple<String, String>>(name, new Tuple<String, String>(value, URLEncoder.encode(value, "UTF-8"))));
        return this;
    }

    public Query appendIf(String name, String value) throws UnsupportedEncodingException {
        if (value != null) {
            this.append(name, value);
        }
        return this;
    }

    public Query appendIf(String name, Integer value) throws UnsupportedEncodingException {
        if (value != null) {
            this.append(name, value.toString());
        }
        return this;
    }

    public Query appendIf(String name, Boolean value) throws UnsupportedEncodingException {
        if (value != null) {
            this.append(name, value.toString());
        }
        return this;
    }

    public Query appendIf(String name, GitlabAccessLevel value) throws UnsupportedEncodingException {
        if (value != null) {
            this.append(name, Integer.toString(value.accessValue));
        }
        return this;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        for (Tuple<String, Tuple<String, String>> param : this.params) {
            if (builder.length() == 0) {
                builder.append('?');
            } else {
                builder.append('&');
            }
            builder.append((String)param._1);
            builder.append('=');
            builder.append((String)((Tuple)param._2)._2);
        }
        return builder.toString();
    }

    private class Tuple<T1, T2> {
        T1 _1;
        T2 _2;

        public Tuple(T1 _1, T2 _2) {
            this._1 = _1;
            this._2 = _2;
        }
    }
}

