/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.http;

import com.talanlabs.gitlab.api.GitLabAPI;
import com.talanlabs.gitlab.api.Paged;
import java.io.IOException;
import java.util.List;

public class PagedImpl<T>
implements Paged<T> {
    private final GitLabAPI gitLabAPI;
    private final Class<T[]> type;
    private final List<T> results;
    private final Integer total;
    private final Integer totalPage;
    private final Integer perPage;
    private final Integer page;
    private final Integer nextPage;
    private final Integer prevPage;
    private String firstPageUrl;
    private String nextPageUrl;
    private String prevPageUrl;
    private String lastPageUrl;

    public PagedImpl(GitLabAPI gitLabAPI, Class<T[]> type, List<T> results, Integer total, Integer totalPage, Integer perPage, Integer page, Integer nextPage, Integer prevPage, String link) {
        this.gitLabAPI = gitLabAPI;
        this.type = type;
        this.results = results;
        this.total = total;
        this.totalPage = totalPage;
        this.perPage = perPage;
        this.page = page;
        this.nextPage = nextPage;
        this.prevPage = prevPage;
        this.parseLink(link);
    }

    private void parseLink(String linkHeader) {
        if (linkHeader != null && linkHeader.length() > 0) {
            String[] links;
            for (String link : links = linkHeader.split(",")) {
                String linkPart;
                String[] segments = link.split(";");
                if (segments.length < 2 || !(linkPart = segments[0].trim()).startsWith("<") || !linkPart.endsWith(">")) continue;
                linkPart = linkPart.substring(1, linkPart.length() - 1);
                for (int i = 1; i < segments.length; ++i) {
                    String[] rel = segments[i].trim().split("=");
                    if (rel.length < 2 || !"rel".equals(rel[0])) continue;
                    String relValue = rel[1];
                    if (relValue.startsWith("\"") && relValue.endsWith("\"")) {
                        relValue = relValue.substring(1, relValue.length() - 1);
                    }
                    if ("first".equals(relValue)) {
                        this.firstPageUrl = linkPart;
                        continue;
                    }
                    if ("last".equals(relValue)) {
                        this.lastPageUrl = linkPart;
                        continue;
                    }
                    if ("next".equals(relValue)) {
                        this.nextPageUrl = linkPart;
                        continue;
                    }
                    if (!"prev".equals(relValue)) continue;
                    this.prevPageUrl = linkPart;
                }
            }
        }
    }

    @Override
    public List<T> getResults() {
        return this.results;
    }

    @Override
    public Integer getTotal() {
        return this.total;
    }

    @Override
    public Integer getTotalPage() {
        return this.totalPage;
    }

    @Override
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public Integer getPage() {
        return this.page;
    }

    @Override
    public Integer getNextPage() {
        return this.nextPage;
    }

    @Override
    public Integer getPrevPage() {
        return this.prevPage;
    }

    @Override
    public Paged<T> firstPage() throws IOException {
        if (this.firstPageUrl == null) {
            return null;
        }
        return this.gitLabAPI.retrieve().toPaged(this.gitLabAPI.removeAPIUrl(this.firstPageUrl), this.type);
    }

    @Override
    public Paged<T> nextPage() throws IOException {
        if (this.nextPageUrl == null) {
            return null;
        }
        return this.gitLabAPI.retrieve().toPaged(this.gitLabAPI.removeAPIUrl(this.nextPageUrl), this.type);
    }

    @Override
    public Paged<T> prevPage() throws IOException {
        if (this.prevPageUrl == null) {
            return null;
        }
        return this.gitLabAPI.retrieve().toPaged(this.gitLabAPI.removeAPIUrl(this.prevPageUrl), this.type);
    }

    @Override
    public Paged<T> lastPage() throws IOException {
        if (this.lastPageUrl == null) {
            return null;
        }
        return this.gitLabAPI.retrieve().toPaged(this.gitLabAPI.removeAPIUrl(this.lastPageUrl), this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PagedImpl{");
        sb.append("gitLabAPI=").append(this.gitLabAPI);
        sb.append(", type=").append(this.type);
        sb.append(", results=").append(this.results);
        sb.append(", total=").append(this.total);
        sb.append(", totalPage=").append(this.totalPage);
        sb.append(", perPage=").append(this.perPage);
        sb.append(", page=").append(this.page);
        sb.append(", nextPage=").append(this.nextPage);
        sb.append(", prevPage=").append(this.prevPage);
        sb.append(", firstPageUrl='").append(this.firstPageUrl).append('\'');
        sb.append(", nextPageUrl='").append(this.nextPageUrl).append('\'');
        sb.append(", prevPageUrl='").append(this.prevPageUrl).append('\'');
        sb.append(", lastPageUrl='").append(this.lastPageUrl).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

