/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.services;

import com.talanlabs.gitlab.api.GitLabAPI;
import com.talanlabs.gitlab.api.Paged;
import com.talanlabs.gitlab.api.Pagination;
import com.talanlabs.gitlab.api.http.Query;
import com.talanlabs.gitlab.api.models.buildvariables.GitLabVariable;
import java.io.IOException;
import java.io.Serializable;

public class GitLabAPIBuildVariables {
    private final GitLabAPI gitLabAPI;

    public GitLabAPIBuildVariables(GitLabAPI gitLabAPI) {
        this.gitLabAPI = gitLabAPI;
    }

    public Paged<GitLabVariable> getProjectVariables(Serializable projectId, Pagination pagination) throws IOException {
        Query q = pagination != null ? pagination.asQuery() : Query.newQuery();
        String parameters = q.build();
        String tailUrl = String.format("/projects/%s/variables%s", this.gitLabAPI.sanitize(projectId), parameters);
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabVariable[].class);
    }

    public GitLabVariable getProjectVariable(Serializable projectId, String key) throws IOException {
        String tailUrl = String.format("/projects/%s/variables/%s", this.gitLabAPI.sanitize(projectId), this.gitLabAPI.sanitize(key));
        return this.gitLabAPI.retrieve().to(tailUrl, GitLabVariable.class);
    }
}

