/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.services;

import com.talanlabs.gitlab.api.GitLabAPI;
import com.talanlabs.gitlab.api.Paged;
import com.talanlabs.gitlab.api.Pagination;
import com.talanlabs.gitlab.api.http.Query;
import com.talanlabs.gitlab.api.models.commits.GitLabCommit;
import com.talanlabs.gitlab.api.models.commits.GitLabCommitComments;
import com.talanlabs.gitlab.api.models.commits.GitLabCommitDiff;
import com.talanlabs.gitlab.api.models.commits.GitLabCommitStatus;
import java.io.IOException;
import java.io.Serializable;

public class GitLabAPICommits {
    private final GitLabAPI gitLabAPI;

    public GitLabAPICommits(GitLabAPI gitLabAPI) {
        this.gitLabAPI = gitLabAPI;
    }

    public Paged<GitLabCommit> getAllCommits(Serializable projectId, Pagination pagination) throws IOException {
        Query query = pagination != null ? pagination.asQuery() : Query.newQuery();
        String tailUrl = String.format("/projects/%s/repository/commits%s", this.gitLabAPI.sanitize(projectId), query.build());
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabCommit[].class);
    }

    public GitLabCommit getCommit(Serializable projectId, String commitHash) throws IOException {
        String tailUrl = String.format("/projects/%s/repository/commits/%s", this.gitLabAPI.sanitize(projectId), commitHash);
        return this.gitLabAPI.retrieve().to(tailUrl, GitLabCommit.class);
    }

    public Paged<GitLabCommitDiff> getCommitDiffs(Serializable projectId, String commitHash, Pagination pagination) throws IOException {
        Query query = pagination != null ? pagination.asQuery() : Query.newQuery();
        String tailUrl = String.format("/projects/%s/repository/commits/%s/diff%s", this.gitLabAPI.sanitize(projectId), commitHash, query.build());
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabCommitDiff[].class);
    }

    public Paged<GitLabCommitComments> getCommitComments(Serializable projectId, String commitHash, Pagination pagination) throws IOException {
        Query query = pagination != null ? pagination.asQuery() : Query.newQuery();
        String tailUrl = String.format("/projects/%s/repository/commits/%s/comments%s", this.gitLabAPI.sanitize(projectId), commitHash, query.build());
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabCommitComments[].class);
    }

    public GitLabCommitComments postCommitComments(Serializable projectId, String commitHash, String note, String path, Integer line, String lineType) throws IOException {
        String tailUrl = String.format("/projects/%s/repository/commits/%s/comments", this.gitLabAPI.sanitize(projectId), commitHash);
        return this.gitLabAPI.dispatch().with("note", note).with("path", path).with("line", line).with("line_type", lineType).to(tailUrl, GitLabCommitComments.class);
    }

    public Paged<GitLabCommitStatus> getCommitStatuses(Serializable projectId, String commitHash, Pagination pagination) throws IOException {
        Query query = pagination != null ? pagination.asQuery() : Query.newQuery();
        String tailUrl = String.format("/projects/%s/repository/commits/%s/statuses%s", this.gitLabAPI.sanitize(projectId), commitHash, query.build());
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabCommitStatus[].class);
    }

    public GitLabCommitStatus postCommitStatus(Serializable projectId, String commitHash, String state, String ref, String name, String targetUrl, String description) throws IOException {
        String tailUrl = String.format("/projects/%s/statuses/%s", this.gitLabAPI.sanitize(projectId), commitHash);
        return this.gitLabAPI.dispatch().with("state", state).with("ref", ref).with("name", name).with("target_url", targetUrl).with("description", description).to(tailUrl, GitLabCommitStatus.class);
    }
}

