/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.services;

import com.talanlabs.gitlab.api.GitLabAPI;
import com.talanlabs.gitlab.api.Paged;
import com.talanlabs.gitlab.api.Pagination;
import com.talanlabs.gitlab.api.http.Query;
import com.talanlabs.gitlab.api.models.repositories.GitLabRepositoryTree;
import java.io.IOException;
import java.io.Serializable;

public class GitLabAPIRepositories {
    private final GitLabAPI gitLabAPI;

    public GitLabAPIRepositories(GitLabAPI gitLabAPI) {
        this.gitLabAPI = gitLabAPI;
    }

    public Paged<GitLabRepositoryTree> getRepositoryTrees(Serializable projectId, Pagination pagination, String path, String refName) throws IOException {
        Query q = pagination != null ? pagination.asQuery() : Query.newQuery();
        String parameters = q.appendIf("refName", refName).appendIf("path", path).build();
        String tailUrl = String.format("/projects/%s/repository/tree%s", this.gitLabAPI.sanitize(projectId), parameters);
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabRepositoryTree[].class);
    }

    public byte[] getRawFileContent(Serializable projectId, String sha, String filepath) throws IOException {
        String parameters = Query.newQuery().append("filepath", filepath).build();
        String tailUrl = String.format("/projects/%s/repository/blobs/%s%s", this.gitLabAPI.sanitize(projectId), sha, parameters);
        return this.gitLabAPI.retrieve().to(tailUrl, byte[].class);
    }
}

