/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.v4;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.talanlabs.gitlab.api.v4.AuthMethod;
import com.talanlabs.gitlab.api.v4.TokenType;
import com.talanlabs.gitlab.api.v4.http.GitLabHTTPRequestor;
import com.talanlabs.gitlab.api.v4.services.GitLabAPIBuildVariables;
import com.talanlabs.gitlab.api.v4.services.GitLabAPIBuilds;
import com.talanlabs.gitlab.api.v4.services.GitLabAPICommits;
import com.talanlabs.gitlab.api.v4.services.GitLabAPIProjects;
import com.talanlabs.gitlab.api.v4.services.GitLabAPIRepositories;
import com.talanlabs.gitlab.api.v4.services.GitLabAPIUsers;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;

public class GitLabAPI {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String API_NAMESPACE = "/api/v4";
    private final String hostUrl;
    private final String apiToken;
    private final TokenType tokenType;
    private final AuthMethod authMethod;
    private final GitLabAPICommits gitLabAPICommits;
    private final GitLabAPIProjects gitLabAPIProjects;
    private final GitLabAPIUsers gitLabAPIUsers;
    private final GitLabAPIBuilds gitLabAPIBuilds;
    private final GitLabAPIRepositories gitLabAPIRepositories;
    private final GitLabAPIBuildVariables gitLabAPIBuildVariables;
    private boolean ignoreCertificateErrors = false;
    private Proxy proxy = null;
    private int requestTimeout = 0;

    private GitLabAPI(String hostUrl, String apiToken, TokenType tokenType, AuthMethod method) {
        this.hostUrl = hostUrl.endsWith("/") ? hostUrl.replaceAll("/$", "") : hostUrl;
        this.apiToken = apiToken;
        this.tokenType = tokenType;
        this.authMethod = method;
        this.gitLabAPICommits = new GitLabAPICommits(this);
        this.gitLabAPIProjects = new GitLabAPIProjects(this);
        this.gitLabAPIUsers = new GitLabAPIUsers(this);
        this.gitLabAPIBuilds = new GitLabAPIBuilds(this);
        this.gitLabAPIRepositories = new GitLabAPIRepositories(this);
        this.gitLabAPIBuildVariables = new GitLabAPIBuildVariables(this);
    }

    public static GitLabAPI connect(String hostUrl, String apiToken) {
        return new GitLabAPI(hostUrl, apiToken, TokenType.PRIVATE_TOKEN, AuthMethod.HEADER);
    }

    public static GitLabAPI connect(String hostUrl, String apiToken, TokenType tokenType) {
        return new GitLabAPI(hostUrl, apiToken, tokenType, AuthMethod.HEADER);
    }

    public static GitLabAPI connect(String hostUrl, String apiToken, TokenType tokenType, AuthMethod method) {
        return new GitLabAPI(hostUrl, apiToken, tokenType, method);
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public GitLabAPI setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.ignoreCertificateErrors = ignoreCertificateErrors;
        return this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public GitLabAPI setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public GitLabAPI setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public GitLabHTTPRequestor retrieve() {
        return new GitLabHTTPRequestor(this).authenticate(this.apiToken, this.tokenType, this.authMethod);
    }

    public GitLabHTTPRequestor dispatch() {
        return new GitLabHTTPRequestor(this).authenticate(this.apiToken, this.tokenType, this.authMethod).method("POST");
    }

    public URL getAPIUrl(String tailAPIUrl) throws IOException {
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this.hostUrl + API_NAMESPACE + tailAPIUrl);
    }

    public URL getUrl(String tailAPIUrl) throws IOException {
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this.hostUrl + tailAPIUrl);
    }

    public String removeAPIUrl(String url) {
        String withoutHost = url.substring(this.hostUrl.length());
        return withoutHost.substring(withoutHost.indexOf(API_NAMESPACE) + API_NAMESPACE.length());
    }

    public String sanitize(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(String.valueOf(value), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public GitLabAPICommits getGitLabAPICommits() {
        return this.gitLabAPICommits;
    }

    public GitLabAPIProjects getGitLabAPIProjects() {
        return this.gitLabAPIProjects;
    }

    public GitLabAPIUsers getGitLabAPIUsers() {
        return this.gitLabAPIUsers;
    }

    public GitLabAPIBuilds getGitLabAPIBuilds() {
        return this.gitLabAPIBuilds;
    }

    public GitLabAPIRepositories getGitLabAPIRepositories() {
        return this.gitLabAPIRepositories;
    }

    public GitLabAPIBuildVariables getGitLabAPIBuildVariables() {
        return this.gitLabAPIBuildVariables;
    }
}

