/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public interface Paged<T>
extends Iterable {
    public List<T> getResults();

    public Integer getTotal();

    public Integer getTotalPage();

    public Integer getPerPage();

    public Integer getPage();

    public Integer getNextPage();

    public Integer getPrevPage();

    public Paged<T> firstPage() throws IOException;

    public Paged<T> nextPage() throws IOException;

    public Paged<T> prevPage() throws IOException;

    public Paged<T> lastPage() throws IOException;

    default public Iterator<Paged<T>> iterator() {
        return new Iterator<Paged<T>>(){

            @Override
            public boolean hasNext() {
                return Paged.this.getPage().equals(Paged.this.getTotalPage());
            }

            @Override
            public Paged<T> next() {
                try {
                    return Paged.this.nextPage();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

