/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.v4.services;

import com.talanlabs.gitlab.api.Paged;
import com.talanlabs.gitlab.api.v4.GitLabAPI;
import com.talanlabs.gitlab.api.v4.Pagination;
import com.talanlabs.gitlab.api.v4.http.Query;
import com.talanlabs.gitlab.api.v4.models.builds.GitLabBuild;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.StringJoiner;

public class GitLabAPIBuilds {
    private final GitLabAPI gitLabAPI;

    public GitLabAPIBuilds(GitLabAPI gitLabAPI) {
        this.gitLabAPI = gitLabAPI;
    }

    public Paged<GitLabBuild> getAllBuilds(Serializable projectId, Pagination pagination, String ... scopes) throws IOException {
        Query query = pagination != null ? pagination.asQuery() : Query.newQuery();
        if (scopes != null && scopes.length > 0) {
            StringJoiner stringJoiner = new StringJoiner(",");
            Arrays.stream(scopes).forEach(stringJoiner::add);
            query.append("scope", stringJoiner.toString()).build();
        }
        String tailUrl = String.format("/projects/%s/builds%s", this.gitLabAPI.sanitize(projectId), query.build());
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabBuild[].class);
    }

    public byte[] getBuildArtifacts(Serializable projectId, Integer buildId) throws IOException {
        String tailUrl = String.format("/projects/%s/builds/%s/artifacts", this.gitLabAPI.sanitize(projectId), buildId);
        return this.gitLabAPI.retrieve().to(tailUrl, byte[].class);
    }
}

