/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.v4.services;

import com.talanlabs.gitlab.api.Paged;
import com.talanlabs.gitlab.api.v4.GitLabAPI;
import com.talanlabs.gitlab.api.v4.Pagination;
import com.talanlabs.gitlab.api.v4.http.Query;
import com.talanlabs.gitlab.api.v4.models.users.GitLabUser;
import java.io.IOException;

public class GitLabAPIUsers {
    private final GitLabAPI gitLabAPI;

    public GitLabAPIUsers(GitLabAPI gitLabAPI) {
        this.gitLabAPI = gitLabAPI;
    }

    public GitLabUser getUser() throws IOException {
        String tailUrl = "/user";
        return this.gitLabAPI.retrieve().to(tailUrl, GitLabUser.class);
    }

    public Paged<GitLabUser> getUsers(String emailOrUsername, Pagination pagination) throws IOException {
        Query q = pagination != null ? pagination.asQuery() : Query.newQuery();
        String parameters = q.appendIf("search", emailOrUsername).build();
        String tailUrl = "/users" + parameters;
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabUser[].class);
    }
}

