/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.gitlab.api.v3.services;

import com.talanlabs.gitlab.api.Paged;
import com.talanlabs.gitlab.api.v3.GitLabAPI;
import com.talanlabs.gitlab.api.v3.Pagination;
import com.talanlabs.gitlab.api.v3.http.Query;
import com.talanlabs.gitlab.api.v3.models.projects.GitLabProject;
import java.io.IOException;
import java.io.Serializable;

public class GitLabAPIProjects {
    private final GitLabAPI gitLabAPI;

    public GitLabAPIProjects(GitLabAPI gitLabAPI) {
        this.gitLabAPI = gitLabAPI;
    }

    public Paged<GitLabProject> getProjects(Pagination pagination, Boolean archived, String orderBy, String sort, String search, Boolean ciEnabledFirst) throws IOException {
        return this.getProjects(null, pagination, archived, orderBy, sort, search, ciEnabledFirst);
    }

    public Paged<GitLabProject> getProjectOwneds(Pagination pagination, Boolean archived, String orderBy, String sort, String search, Boolean ciEnabledFirst) throws IOException {
        return this.getProjects("/owned", pagination, archived, orderBy, sort, search, ciEnabledFirst);
    }

    public Paged<GitLabProject> getProjectAlls(Pagination pagination, Boolean archived, String orderBy, String sort, String search, Boolean ciEnabledFirst) throws IOException {
        return this.getProjects("/all", pagination, archived, orderBy, sort, search, ciEnabledFirst);
    }

    private Paged<GitLabProject> getProjects(String prefix, Pagination pagination, Boolean archived, String orderBy, String sort, String search, Boolean ciEnabledFirst) throws IOException {
        Query q = pagination != null ? pagination.asQuery() : Query.newQuery();
        String parameters = q.appendIf("archived", archived).appendIf("order_by", orderBy).appendIf("sort", sort).appendIf("search", this.gitLabAPI.sanitize(search)).appendIf("ciEnabledFirst", ciEnabledFirst).build();
        String tailUrl = "/projects";
        if (prefix != null) {
            tailUrl = tailUrl + prefix;
        }
        tailUrl = tailUrl + parameters;
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabProject[].class);
    }

    public GitLabProject getProject(Serializable projectId) throws IOException {
        String tailUrl = String.format("/projects/%s", this.gitLabAPI.sanitize(projectId));
        return this.gitLabAPI.retrieve().to(tailUrl, GitLabProject.class);
    }

    public Paged<GitLabProject> getProjectsSearchByName(String query, Pagination pagination, String orderBy, String sort) throws IOException {
        Query q = pagination != null ? pagination.asQuery() : Query.newQuery();
        String parameters = q.appendIf("orderBy", orderBy).appendIf("sort", sort).build();
        String tailUrl = String.format("/projects/search/%s%s", this.gitLabAPI.sanitize(query), parameters);
        return this.gitLabAPI.retrieve().toPaged(tailUrl, GitLabProject[].class);
    }
}

