/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.targomo.client.api.enums.EdgeWeightType;
import com.targomo.client.api.enums.Format;
import com.targomo.client.api.enums.PathSerializerType;
import com.targomo.client.api.enums.PolygonIntersectionMode;
import com.targomo.client.api.enums.PolygonSerializerType;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.geo.DefaultSourceCoordinate;
import com.targomo.client.api.geo.DefaultTargetCoordinate;
import com.targomo.client.api.json.DefaultSourceCoordinateMapDeserializer;
import com.targomo.client.api.json.DefaultSourceCoordinateMapSerializer;
import com.targomo.client.api.json.DefaultTargetCoordinateMapDeserializer;
import com.targomo.client.api.json.DefaultTargetCoordinateMapSerializer;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.statistic.PoiType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="travel_option")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class TravelOptions
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private Integer id;
    @JsonDeserialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapSerializer.class)
    @Transient
    private Map<String, Coordinate> sources = new HashMap<String, Coordinate>();
    @JsonDeserialize(contentAs=DefaultTargetCoordinate.class, using=DefaultTargetCoordinateMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceCoordinate.class, using=DefaultTargetCoordinateMapSerializer.class)
    @Transient
    private Map<String, Coordinate> targets = new HashMap<String, Coordinate>();
    @Column(name="bike_speed")
    private double bikeSpeed = 15.0;
    @Column(name="bike_uphill")
    private double bikeUphill = 20.0;
    @Column(name="bike_downhill")
    private double bikeDownhill = -10.0;
    @Column(name="walk_speed")
    private double walkSpeed = 5.0;
    @Column(name="walk_uphill")
    private double walkUphill = 10.0;
    @Column(name="walk_downhill")
    private double walkDownhill = 0.0;
    @Column(name="rush_hour")
    private Boolean rushHour = false;
    @Transient
    private List<Integer> travelTimes = Arrays.asList(600, 1200, 1800);
    @Column(name="travel_type")
    private TravelType travelType = TravelType.UNSPECIFIED;
    @Column(name="elevation_enabled")
    private Boolean elevationEnabled = false;
    @Transient
    private Boolean appendTravelTimes = false;
    @Transient
    private Boolean pointReduction = true;
    @Transient
    private Boolean reverse = false;
    @Transient
    private Long minPolygonHoleSize = 100000000L;
    @Column(name="time")
    private Integer time = 32400;
    @Column(name="date")
    private Integer date = 20170214;
    @Column(name="frame")
    private Integer frame = 18000;
    @Transient
    private Integer recommendations = 0;
    @Transient
    private Integer srid = null;
    @Column(name="max_transfers")
    private Integer maxTransfers = null;
    @Transient
    private Double buffer = null;
    @Transient
    private Double simplify = null;
    @Transient
    private PolygonIntersectionMode intersectionMode = PolygonIntersectionMode.UNION;
    @Transient
    private PathSerializerType pathSerializer = PathSerializerType.COMPACT_PATH_SERIALIZER;
    @Transient
    private PolygonSerializerType polygonSerializerType = PolygonSerializerType.JSON_POLYGON_SERIALIZER;
    @Column(name="max_edge_weight")
    private Integer maxEdgeWeight = 1800;
    @Column(name="service_url")
    private String serviceUrl = "";
    @Column(name="fallback_service_url")
    private String fallbackServiceUrl = "";
    @Column(name="service_key")
    private String serviceKey = "";
    @Transient
    private boolean onlyPrintReachablePoints = true;
    @JsonProperty(value="edgeWeight")
    @Column(name="edge_weight_type")
    private EdgeWeightType edgeWeightType = EdgeWeightType.TIME;
    @Transient
    private List<Short> statisticIds;
    @Column(name="statistic_group_id")
    private Integer statisticGroupId;
    @Column(name="statistic_service_url")
    private String statisticServiceUrl = "https://api.targomo.com/statistics/";
    @Column(name="poi_service_url")
    private String pointOfInterestServiceUrl = "https://api.targomo.com/pointsofinterest/";
    @Column(name="overpass_query")
    private String overpassQuery;
    @Column(name="overpass_service_url")
    private String overpassServiceUrl = "https://api.targomo.com/overpass/";
    @Column(name="inter_service_key")
    private String interServiceKey = "";
    @Transient
    private Format format;
    @Transient
    private String boundingBox;
    @Transient
    private Set<TravelType> travelTypes = new HashSet<TravelType>();
    @Transient
    private Set<PoiType> osmTypes = new HashSet<PoiType>();
    @Transient
    private Set<PoiType> customPois = new HashSet<PoiType>();

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(String boundingBox) {
        this.boundingBox = boundingBox;
    }

    public Set<PoiType> getCustomPois() {
        return this.customPois;
    }

    public void setCustomPois(Set<PoiType> customPois) {
        this.customPois = customPois;
    }

    public Set<TravelType> getTravelTypes() {
        return this.travelTypes;
    }

    public void setTravelTypes(Set<TravelType> travelTypes) {
        this.travelTypes = travelTypes;
    }

    public Set<PoiType> getOsmTypes() {
        return this.osmTypes;
    }

    public void setOsmTypes(Set<PoiType> osmTypes) {
        this.osmTypes = osmTypes;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @JsonIgnore
    public double[][] getSourceCoordinates() {
        return this.getCoordinates(this.sources);
    }

    @JsonIgnore
    public double[][] getTargetCoordinates() {
        return this.getCoordinates(this.targets);
    }

    private double[][] getCoordinates(Map<String, Coordinate> points) {
        Coordinate[] pointList = points.values().toArray(new Coordinate[0]);
        double[][] coordinates = new double[points.size()][];
        for (int i = 0; i < points.size(); ++i) {
            coordinates[i] = new double[]{pointList[i].getX(), pointList[i].getY()};
        }
        return coordinates;
    }

    public Map<String, Coordinate> getSources() {
        return this.sources;
    }

    public void setSources(Map<String, Coordinate> sources) {
        this.sources = sources;
    }

    public Map<String, Coordinate> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, Coordinate> targets) {
        this.targets = targets;
    }

    public void addAllTargets(Map<String, Coordinate> targets) {
        this.targets.putAll(targets);
    }

    public void addAllTargets(Collection<Coordinate> targets) {
        this.targets = targets.stream().collect(Collectors.toMap(t -> t.getId(), Function.identity()));
    }

    public double getBikeSpeed() {
        return this.bikeSpeed;
    }

    public void setBikeSpeed(double bikeSpeed) {
        this.bikeSpeed = bikeSpeed;
    }

    public double getBikeUphill() {
        return this.bikeUphill;
    }

    public void setBikeUphill(double bikeUphill) {
        this.bikeUphill = bikeUphill;
    }

    public double getBikeDownhill() {
        return this.bikeDownhill;
    }

    public void setBikeDownhill(double bikeDownhill) {
        this.bikeDownhill = bikeDownhill;
    }

    public double getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setWalkSpeed(double walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public double getWalkUphill() {
        return this.walkUphill;
    }

    public void setWalkUphill(double walkUphill) {
        this.walkUphill = walkUphill;
    }

    public double getWalkDownhill() {
        return this.walkDownhill;
    }

    public void setWalkDownhill(double walkDownhill) {
        this.walkDownhill = walkDownhill;
    }

    public void setRushHour(boolean rushHourEnabled) {
        this.rushHour = rushHourEnabled;
    }

    public boolean getRushHour() {
        return this.rushHour;
    }

    public List<Integer> getTravelTimes() {
        return this.travelTimes;
    }

    public void setTravelTimes(List<Integer> travelTimes) {
        this.travelTimes = travelTimes;
    }

    public TravelType getTravelType() {
        return this.travelType;
    }

    public void setTravelType(TravelType travelType) {
        this.travelType = travelType;
    }

    public Boolean isElevationEnabled() {
        return this.elevationEnabled;
    }

    public void setElevationEnabled(Boolean elevationEnabled) {
        this.elevationEnabled = elevationEnabled;
    }

    public long getMinPolygonHoleSize() {
        return this.minPolygonHoleSize;
    }

    public void setMinPolygonHoleSize(long minPolygonHoleSize) {
        this.minPolygonHoleSize = minPolygonHoleSize;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(Integer time) {
        this.time = time;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(Integer date) {
        this.date = date;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public int getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(int recommendations) {
        this.recommendations = recommendations;
    }

    public PolygonIntersectionMode getIntersectionMode() {
        return this.intersectionMode;
    }

    public void setIntersectionMode(PolygonIntersectionMode intersectionMode) {
        this.intersectionMode = intersectionMode;
    }

    public PathSerializerType getPathSerializer() {
        return this.pathSerializer;
    }

    public void setPathSerializer(PathSerializerType pathSerializer) {
        this.pathSerializer = pathSerializer;
    }

    public PolygonSerializerType getPolygonSerializerType() {
        return this.polygonSerializerType;
    }

    public void setPolygonSerializerType(PolygonSerializerType polygonSerializerType) {
        this.polygonSerializerType = polygonSerializerType;
    }

    public boolean isPointReduction() {
        return this.pointReduction;
    }

    public void setPointReduction(boolean pointReduction) {
        this.pointReduction = pointReduction;
    }

    @JsonIgnore
    @Deprecated
    public int getMaxRoutingTime() {
        if (this.edgeWeightType == EdgeWeightType.TIME) {
            return this.maxEdgeWeight;
        }
        return 0;
    }

    @JsonIgnore
    @Deprecated
    public void setMaxRoutingTime(int maxRoutingTime) {
        this.maxEdgeWeight = maxRoutingTime;
        this.edgeWeightType = EdgeWeightType.TIME;
    }

    @JsonIgnore
    @Deprecated
    public Integer getMaxRoutingLength() {
        if (this.edgeWeightType == EdgeWeightType.DISTANCE) {
            return this.maxEdgeWeight;
        }
        return 0;
    }

    @JsonIgnore
    @Deprecated
    public void setMaxRoutingLength(Integer maxRoutingLength) {
        this.maxEdgeWeight = maxRoutingLength;
        this.edgeWeightType = EdgeWeightType.DISTANCE;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public void addSource(Coordinate source) {
        this.sources.put(source.getId(), source);
    }

    public void addTarget(Coordinate target) {
        this.targets.put(target.getId(), target);
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TravelOptions that = (TravelOptions)o;
        if (Double.compare(that.bikeSpeed, this.bikeSpeed) != 0) {
            return false;
        }
        if (Double.compare(that.bikeUphill, this.bikeUphill) != 0) {
            return false;
        }
        if (Double.compare(that.bikeDownhill, this.bikeDownhill) != 0) {
            return false;
        }
        if (Double.compare(that.walkSpeed, this.walkSpeed) != 0) {
            return false;
        }
        if (Double.compare(that.walkUphill, this.walkUphill) != 0) {
            return false;
        }
        if (Double.compare(that.walkDownhill, this.walkDownhill) != 0) {
            return false;
        }
        if (this.rushHour != that.rushHour) {
            return false;
        }
        if (this.onlyPrintReachablePoints != that.onlyPrintReachablePoints) {
            return false;
        }
        if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) {
            return false;
        }
        if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) {
            return false;
        }
        if (this.travelTimes != null ? !this.travelTimes.equals(that.travelTimes) : that.travelTimes != null) {
            return false;
        }
        if (this.travelType != that.travelType) {
            return false;
        }
        if (this.elevationEnabled != null ? !this.elevationEnabled.equals(that.elevationEnabled) : that.elevationEnabled != null) {
            return false;
        }
        if (this.appendTravelTimes != null ? !this.appendTravelTimes.equals(that.appendTravelTimes) : that.appendTravelTimes != null) {
            return false;
        }
        if (this.pointReduction != null ? !this.pointReduction.equals(that.pointReduction) : that.pointReduction != null) {
            return false;
        }
        if (this.reverse != null ? !this.reverse.equals(that.reverse) : that.reverse != null) {
            return false;
        }
        if (this.minPolygonHoleSize != null ? !this.minPolygonHoleSize.equals(that.minPolygonHoleSize) : that.minPolygonHoleSize != null) {
            return false;
        }
        if (this.time != null ? !this.time.equals(that.time) : that.time != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
            return false;
        }
        if (this.frame != null ? !this.frame.equals(that.frame) : that.frame != null) {
            return false;
        }
        if (this.recommendations != null ? !this.recommendations.equals(that.recommendations) : that.recommendations != null) {
            return false;
        }
        if (this.srid != null ? !this.srid.equals(that.srid) : that.srid != null) {
            return false;
        }
        if (this.buffer != null ? !this.buffer.equals(that.buffer) : that.buffer != null) {
            return false;
        }
        if (this.simplify != null ? !this.simplify.equals(that.simplify) : that.simplify != null) {
            return false;
        }
        if (this.intersectionMode != that.intersectionMode) {
            return false;
        }
        if (this.pathSerializer != that.pathSerializer) {
            return false;
        }
        if (this.polygonSerializerType != that.polygonSerializerType) {
            return false;
        }
        if (this.maxEdgeWeight != null ? !this.maxEdgeWeight.equals(that.maxEdgeWeight) : that.maxEdgeWeight != null) {
            return false;
        }
        if (this.serviceUrl != null ? !this.serviceUrl.equals(that.serviceUrl) : that.serviceUrl != null) {
            return false;
        }
        if (this.fallbackServiceUrl != null ? !this.fallbackServiceUrl.equals(that.fallbackServiceUrl) : that.fallbackServiceUrl != null) {
            return false;
        }
        if (this.serviceKey != null ? !this.serviceKey.equals(that.serviceKey) : that.serviceKey != null) {
            return false;
        }
        if (this.edgeWeightType != that.edgeWeightType) {
            return false;
        }
        if (this.statisticIds != null ? !this.statisticIds.equals(that.statisticIds) : that.statisticIds != null) {
            return false;
        }
        if (this.statisticGroupId != null ? !this.statisticGroupId.equals(that.statisticGroupId) : that.statisticGroupId != null) {
            return false;
        }
        if (this.interServiceKey != null ? !this.interServiceKey.equals(that.interServiceKey) : that.interServiceKey != null) {
            return false;
        }
        return this.statisticServiceUrl != null ? this.statisticServiceUrl.equals(that.statisticServiceUrl) : that.statisticServiceUrl == null;
    }

    public int hashCode() {
        int result = this.sources != null ? this.sources.hashCode() : 0;
        result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.bikeSpeed);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.bikeUphill);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.bikeDownhill);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.walkSpeed);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.walkUphill);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.walkDownhill);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.rushHour != null ? this.rushHour.hashCode() : 0);
        result = 31 * result + (this.travelTimes != null ? this.travelTimes.hashCode() : 0);
        result = 31 * result + (this.travelType != null ? this.travelType.hashCode() : 0);
        result = 31 * result + (this.elevationEnabled != null ? this.elevationEnabled.hashCode() : 0);
        result = 31 * result + (this.appendTravelTimes != null ? this.appendTravelTimes.hashCode() : 0);
        result = 31 * result + (this.pointReduction != null ? this.pointReduction.hashCode() : 0);
        result = 31 * result + (this.reverse != null ? this.reverse.hashCode() : 0);
        result = 31 * result + (this.minPolygonHoleSize != null ? this.minPolygonHoleSize.hashCode() : 0);
        result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.frame != null ? this.frame.hashCode() : 0);
        result = 31 * result + (this.recommendations != null ? this.recommendations.hashCode() : 0);
        result = 31 * result + (this.srid != null ? this.srid.hashCode() : 0);
        result = 31 * result + (this.buffer != null ? this.buffer.hashCode() : 0);
        result = 31 * result + (this.simplify != null ? this.simplify.hashCode() : 0);
        result = 31 * result + (this.intersectionMode != null ? this.intersectionMode.hashCode() : 0);
        result = 31 * result + (this.pathSerializer != null ? this.pathSerializer.hashCode() : 0);
        result = 31 * result + (this.polygonSerializerType != null ? this.polygonSerializerType.hashCode() : 0);
        result = 31 * result + (this.maxEdgeWeight != null ? this.maxEdgeWeight.hashCode() : 0);
        result = 31 * result + (this.serviceUrl != null ? this.serviceUrl.hashCode() : 0);
        result = 31 * result + (this.fallbackServiceUrl != null ? this.fallbackServiceUrl.hashCode() : 0);
        result = 31 * result + (this.serviceKey != null ? this.serviceKey.hashCode() : 0);
        result = 31 * result + (this.onlyPrintReachablePoints ? 1 : 0);
        result = 31 * result + (this.edgeWeightType != null ? this.edgeWeightType.hashCode() : 0);
        result = 31 * result + (this.statisticIds != null ? this.statisticIds.hashCode() : 0);
        result = 31 * result + (this.statisticGroupId != null ? this.statisticGroupId.hashCode() : 0);
        result = 31 * result + (this.statisticServiceUrl != null ? this.statisticServiceUrl.hashCode() : 0);
        result = 31 * result + (this.interServiceKey != null ? this.interServiceKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        int maxLen = 5;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" {\n\tsources: ");
        builder.append(this.sources != null ? this.toString(this.sources.entrySet(), 5) : null);
        builder.append("\n\ttargets: ");
        builder.append(this.targets != null ? this.toString(this.targets.entrySet(), 5) : null);
        builder.append("\n\tbikeSpeed: ");
        builder.append(this.bikeSpeed);
        builder.append("\n\tbikeUphill: ");
        builder.append(this.bikeUphill);
        builder.append("\n\tbikeDownhill: ");
        builder.append(this.bikeDownhill);
        builder.append("\n\twalkSpeed: ");
        builder.append(this.walkSpeed);
        builder.append("\n\twalkUphill: ");
        builder.append(this.walkUphill);
        builder.append("\n\twalkDownhill: ");
        builder.append(this.walkDownhill);
        builder.append("\n\trushHour: ");
        builder.append(this.rushHour);
        builder.append("\n\ttravelTimes: ");
        builder.append(this.travelTimes != null ? this.toString(this.travelTimes, 5) : null);
        builder.append("\n\ttravelType: ");
        builder.append((Object)this.travelType);
        builder.append("\n\televationEnabled: ");
        builder.append(this.elevationEnabled);
        builder.append("\n\tappendTravelTimes: ");
        builder.append(this.appendTravelTimes);
        builder.append("\n\tpointReduction: ");
        builder.append(this.pointReduction);
        builder.append("\n\treverse: ");
        builder.append(this.reverse);
        builder.append("\n\tminPolygonHoleSize: ");
        builder.append(this.minPolygonHoleSize);
        builder.append("\n\ttime: ");
        builder.append(this.time);
        builder.append("\n\tdate: ");
        builder.append(this.date);
        builder.append("\n\tframe: ");
        builder.append(this.frame);
        builder.append("\n\trecommendations: ");
        builder.append(this.recommendations);
        builder.append("\n\tsrid: ");
        builder.append(this.srid);
        builder.append("\n\tbuffer: ");
        builder.append(this.buffer);
        builder.append("\n\tsimplify: ");
        builder.append(this.simplify);
        builder.append("\n\tintersectionMode: ");
        builder.append((Object)this.intersectionMode);
        builder.append("\n\tpathSerializer: ");
        builder.append((Object)this.pathSerializer);
        builder.append("\n\tpolygonSerializerType: ");
        builder.append((Object)this.polygonSerializerType);
        builder.append("\n\tmaxEdgeWeight: ");
        builder.append(this.maxEdgeWeight);
        builder.append("\n\tserviceUrl: ");
        builder.append(this.serviceUrl);
        builder.append("\n\tstatisticServiceUrl: ");
        builder.append(this.statisticServiceUrl);
        builder.append("\n\tserviceKey: ");
        builder.append(this.serviceKey);
        builder.append("\n\tonlyPrintReachablePoints: ");
        builder.append(this.onlyPrintReachablePoints);
        builder.append("\n\tedgeWeightType: ");
        builder.append((Object)this.edgeWeightType);
        builder.append("\n\tstatisticIds: ");
        builder.append(this.statisticIds != null ? this.toString(this.statisticIds, 5) : null);
        builder.append("\n\tstatisticGroupId: ");
        builder.append(this.statisticGroupId);
        builder.append("\n}\n");
        builder.append("\n\tinterServiceKey: ");
        builder.append(this.interServiceKey);
        return builder.toString();
    }

    public Coordinate getSource(String id) {
        return this.sources.get(id);
    }

    public Coordinate getTarget(String id) {
        return this.targets.get(id);
    }

    public List<Short> getStatisticIds() {
        return this.statisticIds;
    }

    public void setStatisticIds(List<Short> statisticIds) {
        this.statisticIds = statisticIds;
    }

    public void setOnlyPrintReachablePoints(boolean onlyPrintReachablePoints) {
        this.onlyPrintReachablePoints = onlyPrintReachablePoints;
    }

    public boolean getOnlyPrintReachablePoints() {
        return this.onlyPrintReachablePoints;
    }

    public Double getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Double buffer) {
        this.buffer = buffer;
    }

    public Double getSimplify() {
        return this.simplify;
    }

    public void setSimplify(Double simplify) {
        this.simplify = simplify;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public EdgeWeightType getEdgeWeightType() {
        return this.edgeWeightType;
    }

    public void setEdgeWeightType(EdgeWeightType edgeWeightType) {
        this.edgeWeightType = edgeWeightType;
    }

    public Boolean getAppendTravelTimes() {
        return this.appendTravelTimes;
    }

    public void setAppendTravelTimes(Boolean appendTravelTimes) {
        this.appendTravelTimes = appendTravelTimes;
    }

    public String getStatisticServiceUrl() {
        return this.statisticServiceUrl;
    }

    public void setStatisticServiceUrl(String statisticServiceUrl) {
        this.statisticServiceUrl = statisticServiceUrl;
    }

    public Integer getStatisticGroupId() {
        return this.statisticGroupId;
    }

    public void setStatisticGroupId(Integer statisticGroupId) {
        this.statisticGroupId = statisticGroupId;
    }

    public Integer getMaxEdgeWeight() {
        return this.maxEdgeWeight;
    }

    public void setMaxEdgeWeight(Integer maxEdgeWeight) {
        this.maxEdgeWeight = maxEdgeWeight;
    }

    public void addAllSources(Map<String, Coordinate> inactiveSources) {
        this.sources.putAll(inactiveSources);
    }

    public void clearAndAddSource(String id, Coordinate source) {
        this.sources.clear();
        this.sources.put(id, source);
    }

    public String getFallbackServiceUrl() {
        return this.fallbackServiceUrl;
    }

    public void setFallbackServiceUrl(String fallbackServiceUrl) {
        this.fallbackServiceUrl = fallbackServiceUrl;
    }

    public static void main(String[] args) throws JsonProcessingException, TargomoClientException {
        TravelOptions to = new TravelOptions();
        to.addSource(new DefaultSourceCoordinate("sourceid1", 52.0, 13.0, TravelType.WALK));
        to.addSource(new DefaultSourceCoordinate("sourceid2", 52.0, 13.0));
        to.addTarget(new DefaultTargetCoordinate("target1", 52.0, 13.0));
        to.addTarget(new DefaultTargetCoordinate("target2", 52.0, 13.0));
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(String.format("%s", mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)to)));
        System.out.println(String.format("%s", RequestConfigurator.getConfig(to)));
    }

    public String getPointOfInterestServiceUrl() {
        return this.pointOfInterestServiceUrl;
    }

    public String getOverpassServiceUrl() {
        return this.overpassServiceUrl;
    }

    public void setOverpassServiceUrl(String overpassServiceUrl) {
        this.overpassServiceUrl = overpassServiceUrl;
    }

    public String getOverpassQuery() {
        return this.overpassQuery;
    }

    public void setOverpassQuery(String overpassQuery) {
        this.overpassQuery = overpassQuery;
    }

    public String getInterServiceKey() {
        return this.interServiceKey;
    }

    public void setInterServiceKey(String interServiceKey) {
        this.interServiceKey = interServiceKey;
    }

    public Integer getMaxTransfers() {
        return this.maxTransfers;
    }

    public void setMaxTransfers(Integer maxTransfers) {
        this.maxTransfers = maxTransfers;
    }
}

