/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TravelType {
    UNSPECIFIED("unspecified"),
    WALK("walk"),
    BIKE("bike"),
    TRANSIT("transit"),
    WALKTRANSIT("walktransit"),
    BIKETRANSIT("biketransit"),
    CAR("car");

    private String key;

    private TravelType(String key) {
        this.key = key;
    }

    @JsonCreator
    public static TravelType fromString(String key) {
        return key == null ? null : TravelType.valueOf(key.toUpperCase());
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static TravelType parse(String travelType) {
        switch (travelType.toLowerCase()) {
            case "walk": {
                return WALK;
            }
            case "bike": {
                return BIKE;
            }
            case "car": {
                return CAR;
            }
            case "transit": {
                return TRANSIT;
            }
            case "walktransit": {
                return WALKTRANSIT;
            }
            case "biketransit": {
                return BIKETRANSIT;
            }
        }
        return UNSPECIFIED;
    }

    public boolean isTransit() {
        return this.toString().toLowerCase().contains("transit");
    }
}

