/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.Address;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.request.GetRequest;
import com.targomo.client.api.request.esri.ESRIAuthenticationDetails;
import com.targomo.client.api.response.GeocodingResponse;
import com.targomo.client.api.response.esri.AuthenticationResponse;
import com.targomo.client.api.util.POJOUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.boon.json.JsonFactory;
import org.boon.json.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocodingRequest
implements GetRequest<String, GeocodingResponse> {
    private static final String REST_URI = "http://geocode.arcgis.com";
    private static final String PATH_SINGLE_ADDRESS = "arcgis/rest/services/World/GeocodeServer/findAddressCandidates";
    private static final String URI_AUTHENTICATION = "https://www.arcgis.com";
    private static final String PATH_AUTHENTICATION = "sharing/oauth2/token";
    private static final Integer ESRI_ERROR_INVALID_TOKEN = 498;
    private static final ObjectMapper JSON_PARSER = JsonFactory.create();
    private static final Logger LOGGER = LoggerFactory.getLogger(GeocodingRequest.class);
    private final Client client;
    private final ESRIAuthenticationDetails authenticationDetails;
    private final Map<Option, String> requestOptions;
    private String currentAccessToken = null;

    public GeocodingRequest(Client client) {
        this(client, new EnumMap<Option, String>(Option.class));
    }

    public GeocodingRequest(Client client, Map<Option, String> extraOptions) {
        this(client, null, extraOptions);
    }

    public GeocodingRequest(Client client, ESRIAuthenticationDetails authenticationDetails) {
        this(client, authenticationDetails, new EnumMap<Option, String>(Option.class));
    }

    public GeocodingRequest(Client client, ESRIAuthenticationDetails authenticationDetails, Map<Option, String> extraOptions) {
        this.client = client;
        this.requestOptions = extraOptions;
        this.authenticationDetails = authenticationDetails;
        if ("true".equals(extraOptions.get((Object)Option.FOR_STORAGE))) {
            Objects.requireNonNull(this.authenticationDetails, "client authorization is required for option " + Option.FOR_STORAGE.name + "=true");
        }
    }

    @Override
    public GeocodingResponse get(String singleLineAddress) throws TargomoClientException, ProcessingException {
        return this.get((WebTarget webTarget) -> webTarget.queryParam("singleLine", new Object[]{singleLineAddress}));
    }

    @Override
    public GeocodingResponse get(Address address) throws TargomoClientException, ProcessingException {
        return this.get((WebTarget webTarget) -> this.conditionalQueryParam("address", address.street, this.conditionalQueryParam("address2", address.streetDetails, this.conditionalQueryParam("city", address.city, this.conditionalQueryParam("postal", address.postalCode, this.conditionalQueryParam("countryCode", address.country, (WebTarget)webTarget))))));
    }

    private WebTarget conditionalQueryParam(String key, String value, WebTarget webTarget) {
        if (value == null || value.isEmpty()) {
            return webTarget;
        }
        return webTarget.queryParam(key, new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private GeocodingResponse get(Function<WebTarget, WebTarget> queryPrep) throws TargomoClientException, ProcessingException {
        boolean tokenIsInvalid;
        WebTarget target = queryPrep.apply(this.client.target(REST_URI).path(PATH_SINGLE_ADDRESS).queryParam("f", new Object[]{"json"}));
        if (!this.requestOptions.containsKey((Object)Option.MAX_LOCATIONS)) {
            target = target.queryParam(Option.MAX_LOCATIONS.name, new Object[]{1});
        }
        for (Map.Entry<Option, String> entry : this.requestOptions.entrySet()) {
            target = this.conditionalQueryParam(entry.getKey().name, entry.getValue(), target);
        }
        boolean bl = tokenIsInvalid = this.currentAccessToken == null;
        while (true) {
            WebTarget finalTarget;
            if (this.authenticationDetails != null) {
                if (tokenIsInvalid) {
                    this.authenticateWithAccountAndRetrieveValidToken();
                }
                finalTarget = target.queryParam("token", new Object[]{this.currentAccessToken});
            } else {
                finalTarget = target;
            }
            LOGGER.debug("Executing geocoding request to URI: " + finalTarget.getUri());
            Response response = finalTarget.request().buildGet().invoke();
            try {
                GeocodingResponse reqResponse = this.validateGeocodingResponse(response);
                if (reqResponse.wasErrorResponse() && reqResponse.getError().getCode().equals(ESRI_ERROR_INVALID_TOKEN)) {
                    if (tokenIsInvalid) {
                        throw new TargomoClientException(Thread.currentThread() + "Freshly retrieved token already invalid - should never happen: \n" + POJOUtil.prettyPrintPOJO(reqResponse.getError()));
                    }
                    tokenIsInvalid = true;
                    continue;
                }
                GeocodingResponse geocodingResponse = reqResponse;
                return geocodingResponse;
            }
            finally {
                response.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateWithAccountAndRetrieveValidToken() throws TargomoClientException {
        this.currentAccessToken = null;
        ESRIAuthenticationDetails eSRIAuthenticationDetails = this.authenticationDetails;
        synchronized (eSRIAuthenticationDetails) {
            if (this.currentAccessToken == null) {
                this.currentAccessToken = this.retrieveNewTokenViaAuthentication();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveNewTokenViaAuthentication() throws TargomoClientException {
        AuthenticationResponse auth;
        WebTarget target = this.client.target(URI_AUTHENTICATION).path(PATH_AUTHENTICATION).queryParam("grant_type", new Object[]{"client_credentials"}).queryParam("f", new Object[]{"json"}).queryParam("client_id", new Object[]{this.authenticationDetails.getClientID()}).queryParam("client_secret", new Object[]{this.authenticationDetails.getClientSecret()}).queryParam("expiration", new Object[]{this.authenticationDetails.getTokenExpirationInMinutes()});
        LOGGER.debug("Have to redo authentication for ESRI user with client id: {}", (Object)this.authenticationDetails.getClientID());
        try (Response response = target.request().buildGet().invoke();){
            auth = this.validateAuthenticationResponse(response);
            if (auth.wasErrorResponse()) {
                throw new TargomoClientException("Error occurred during authentication with ESRI Service - \nRequest: \n" + target.getUri() + "\nResponse: \n" + POJOUtil.prettyPrintPOJO(auth.getError()));
            }
        }
        return auth.getAccessToken();
    }

    public GeocodingResponse[] getBatchParallel(int parallelThreads, int triesBeforeFail, String ... addresses) throws TargomoClientException, ProcessingException {
        return this.getBatchParallel(this::get, parallelThreads, triesBeforeFail, addresses);
    }

    public GeocodingResponse[] getBatchParallel(int parallelThreads, int triesBeforeFail, Address ... addresses) throws TargomoClientException, ProcessingException {
        return this.getBatchParallel(this::get, parallelThreads, triesBeforeFail, addresses);
    }

    private <A> GeocodingResponse[] getBatchParallel(GetRequest<A, GeocodingResponse> singleRequest, int parallelThreads, int triesBeforeFail, A[] addresses) throws TargomoClientException, ProcessingException {
        if (parallelThreads < 1) {
            throw new TargomoClientRuntimeException("The number of specified threads has to be equal or greater than one.");
        }
        if (triesBeforeFail < 1) {
            throw new TargomoClientRuntimeException("The number of specified tries has to be equal or greater than one.");
        }
        if (addresses == null || addresses.length == 0) {
            throw new TargomoClientRuntimeException("The addresses array has to be not null and contain at least one element.");
        }
        ExecutorService executor = Executors.newFixedThreadPool(parallelThreads);
        ArrayList<Callable<GeocodingResponse>> requests = new ArrayList<Callable<GeocodingResponse>>();
        for (Object singleAddress : addresses) {
            requests.add(() -> {
                for (int numberOfTries = 0; numberOfTries < triesBeforeFail; ++numberOfTries) {
                    try {
                        return (GeocodingResponse)singleRequest.get(singleAddress);
                    }
                    catch (ServiceUnavailableException serviceUnavailableException) {
                        continue;
                    }
                }
                throw new ServiceUnavailableException("Even after " + triesBeforeFail + " tries the service was still unavailable. Try reducing the thread number or increasing the number of tries.");
            });
        }
        try {
            List results = executor.invokeAll(requests);
            this.shutdownServiceExecutor(executor);
            GeocodingResponse[] resultArray = new GeocodingResponse[addresses.length];
            int i = 0;
            for (Future result : results) {
                resultArray[i++] = (GeocodingResponse)result.get();
            }
            return resultArray;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TargomoClientException("Parallel Execution Failed! Cause: ", e);
        }
    }

    private void shutdownServiceExecutor(ExecutorService executor) throws InterruptedException {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(800L, TimeUnit.MILLISECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw e;
        }
    }

    public GeocodingResponse[] getBatchSequential(String ... addresses) throws TargomoClientException, ProcessingException {
        return this.getBatchSequential(this::get, addresses);
    }

    public GeocodingResponse[] getBatchSequential(Address ... addresses) throws TargomoClientException, ProcessingException {
        return this.getBatchSequential(this::get, addresses);
    }

    public String getCurrentAccessToken() {
        return this.currentAccessToken;
    }

    private <A> GeocodingResponse[] getBatchSequential(GetRequest<A, GeocodingResponse> singleRequest, A[] addresses) throws TargomoClientException, ProcessingException {
        if (addresses == null || addresses.length == 0) {
            throw new TargomoClientException("The addresses array has to be not null and contain at least one element.");
        }
        GeocodingResponse[] batchResults = new GeocodingResponse[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            batchResults[i] = singleRequest.get(addresses[i]);
        }
        return batchResults;
    }

    private GeocodingResponse validateGeocodingResponse(Response response) throws TargomoClientException {
        return this.validateResponse(response, GeocodingResponse::createFromJson);
    }

    private AuthenticationResponse validateAuthenticationResponse(Response response) throws TargomoClientException {
        return this.validateResponse(response, jsonString -> (AuthenticationResponse)JSON_PARSER.fromJson(jsonString, AuthenticationResponse.class));
    }

    private <T> T validateResponse(Response response, Function<String, T> parser) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String jsonString = (String)response.readEntity(String.class);
            return parser.apply(jsonString);
        }
        if (response.getStatus() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
            throw new ServiceUnavailableException();
        }
        throw new TargomoClientException("Request failed with response: \n" + (String)response.readEntity(String.class));
    }

    public static enum Option {
        SOURCE_COUNTRY("sourceCountry"),
        SEARCH_EXTENT("searchExtent"),
        CLOSE_LOCATION("location"),
        SPATIAL_REFERENCE("outSR"),
        MAX_LOCATIONS("maxLocations"),
        FOR_STORAGE("forStorage");

        private String name;

        private Option(String repName) {
            this.name = repName;
        }
    }
}

