/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.geo.DefaultSourceCoordinate;
import com.targomo.client.api.request.config.JacksonRequestConfigurator;
import com.targomo.client.api.request.enums.StatisticMethod;
import com.targomo.client.api.response.StatisticsResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsRequest.class);
    private Client client;
    private TravelOptions travelOptions;

    public StatisticsRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public StatisticsRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public StatisticsResponse get(StatisticMethod method) throws TargomoClientException, JSONException {
        Response response;
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getStatisticServiceUrl()).path(method.getPath()).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        Entity entity = Entity.entity((Object)JacksonRequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug(String.format("Executing statistics request (%s) to URI: '%s'", method.getPath(), target.getUri()));
        try {
            response = target.request().post(entity);
        }
        catch (ProcessingException exception) {
            LOGGER.error(String.format("Executing statistics request (%s) to URI: '%s'", method.getPath(), target.getUri()), (Throwable)exception);
            target = this.client.target(this.travelOptions.getFallbackServiceUrl()).path(method.getPath()).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
            LOGGER.debug(String.format("Executing statistics request (%s) to URI: '%s'", method.getPath(), target.getUri()));
            response = target.request().post(entity);
        }
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateResponse(response, requestStart, roundTripTime);
    }

    public static void main(String[] args) throws TargomoClientException, JSONException {
        TravelOptions options = new TravelOptions();
        options.setMaxRoutingTime(1800);
        options.setTravelType(TravelType.WALK);
        options.addSource(new DefaultSourceCoordinate("1asda", 13.405, 52.52));
        options.setServiceUrl("http://localhost:8081/");
        options.setFallbackServiceUrl("http://localhost:8081/");
        options.setStatisticServiceUrl("http://localhost:8080/");
        options.setServiceKey("uhWrWpUhyZQy8rPfiC7X");
        options.setDate(20150812);
        options.setTime(43200);
        options.setAppendTravelTimes(true);
        options.setStatisticIds(Arrays.asList((short)0, (short)1));
        options.setStatisticGroupId(1);
        StatisticsResponse response = new StatisticsRequest(options).get(StatisticMethod.CHARTS_DEPENDET);
        System.out.println(response.getStatisticResult());
    }

    private StatisticsResponse validateResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return new StatisticsResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart);
        }
        if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
            return new StatisticsResponse(this.travelOptions, "gateway-time-out", roundTripTime, requestStart);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), null);
    }

    private static String parseSources(Map<String, Coordinate> sources) throws JSONException {
        JSONArray sourcesJson = new JSONArray();
        for (Coordinate src : sources.values()) {
            sourcesJson.put((Object)new JSONObject().put("id", (Object)src.getId()).put("y", src.getY()).put("x", src.getX()));
        }
        return sourcesJson.toString();
    }
}

