/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.geo.PoiTargetCoordinate;
import com.targomo.client.api.statistic.PoiType;
import com.targomo.client.api.util.JsonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class OverpassResponse {
    private final TravelOptions travelOptions;
    private final JSONObject result;
    private final long requestEnd;
    private final Map<String, Coordinate> points;
    private List<String> keys = Arrays.asList("amenity", "shop", "tourism");

    public OverpassResponse(TravelOptions travelOptions, JSONObject result, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestEnd = System.currentTimeMillis() - requestStart;
        this.result = result;
        this.points = new HashMap<String, Coordinate>();
        this.parseResults();
    }

    public void parseResults() {
        JSONArray elements = JsonUtil.getJsonArray(this.result, "elements");
        String type = this.travelOptions.getOsmTypes().iterator().next().toString();
        for (int i = 0; i < elements.length(); ++i) {
            PoiTargetCoordinate coordinate;
            JSONObject element = JsonUtil.getJSONObject(elements, i);
            if ("node".equals(JsonUtil.getString(element, "type"))) {
                coordinate = new PoiTargetCoordinate(JsonUtil.getString(element, "id") + type, JsonUtil.getDouble(element, "lon"), JsonUtil.getDouble(element, "lat"));
            } else if ("way".equals(JsonUtil.getString(element, "type")) && element.has("center")) {
                coordinate = new PoiTargetCoordinate(JsonUtil.getString(element, "id") + type, JsonUtil.getDouble(JsonUtil.getJSONObject(element, "center"), "lon"), JsonUtil.getDouble(JsonUtil.getJSONObject(element, "center"), "lat"));
            } else {
                throw new TargomoClientRuntimeException("only way and node are supported, given: " + JsonUtil.getString(element, "type"));
            }
            coordinate.setType(this.getType(element));
            this.points.put(coordinate.getId(), coordinate);
        }
    }

    private PoiType getType(JSONObject element) {
        JSONObject tags = JsonUtil.getJSONObject(element, "tags");
        for (String key : this.travelOptions.getOsmTypes().stream().map(PoiType::getKey).collect(Collectors.toList())) {
            if (!tags.has(key)) continue;
            return new PoiType(key, JsonUtil.getString(tags, key));
        }
        throw new TargomoClientRuntimeException("Not supported type: " + JsonUtil.toString(tags, 2));
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public JSONObject getResult() {
        return this.result;
    }

    public Map<String, Coordinate> getTargets() {
        return this.points;
    }
}

