/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response.statistics;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.util.JsonUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticResult.class);
    private final Map<Integer, Map<Integer, Double>> statistics;
    private final Map<Integer, Integer> reachableTargets;
    private final Map<Integer, Integer> targetTravelTimes;
    private final TravelOptions options;

    public StatisticResult(TravelOptions options, JSONObject jsonResult) {
        this.options = options;
        this.statistics = jsonResult.has("statistics") ? this.parseReachableStatisticsResult(jsonResult) : Collections.emptyMap();
        this.reachableTargets = jsonResult.has("reachableTargets") ? this.parseReachableTargetsResult(jsonResult) : Collections.emptyMap();
        this.targetTravelTimes = jsonResult.has("targetTravelTimes") ? this.parseTargetTravelTimes(jsonResult) : Collections.emptyMap();
    }

    private Map<Integer, Integer> parseReachableTargetsResult(JSONObject jsonResult) {
        TreeMap<Integer, Integer> reachableTargets = new TreeMap<Integer, Integer>();
        JSONObject minuteToReachableTargets = JsonUtil.getJSONObject(jsonResult, "reachableTargets");
        for (Integer minute : JsonUtil.getSortedIntKeySet(minuteToReachableTargets)) {
            if (minute > this.options.getMaxRoutingTime()) continue;
            reachableTargets.put(minute, JsonUtil.getInt(minuteToReachableTargets, minute + ""));
        }
        return reachableTargets;
    }

    private Map<Integer, Integer> parseTargetTravelTimes(JSONObject jsonResult) {
        TreeMap<Integer, Integer> targetTravelTimes = new TreeMap<Integer, Integer>();
        JSONObject targetToMinute = JsonUtil.getJSONObject(jsonResult, "targetTravelTimes");
        for (Integer targetId : JsonUtil.getSortedIntKeySet(targetToMinute)) {
            if (JsonUtil.getInt(targetToMinute, targetId + "") > this.options.getMaxRoutingTime()) continue;
            targetTravelTimes.put(targetId, JsonUtil.getInt(targetToMinute, targetId + ""));
        }
        return targetTravelTimes;
    }

    public Map<Integer, Map<Integer, Double>> parseReachableStatisticsResult(JSONObject result) {
        long start = System.currentTimeMillis();
        HashMap<Integer, Map<Integer, Double>> reachablePersonsByStatistic = new HashMap<Integer, Map<Integer, Double>>();
        JSONObject statistics = JsonUtil.getJSONObject(result, "statistics");
        for (Integer statistic : JsonUtil.getSortedIntKeySet(statistics)) {
            JSONObject minuteToValues = JsonUtil.getJSONObject(statistics, statistic + "");
            TreeMap<Integer, Double> reachablePersons = new TreeMap<Integer, Double>();
            for (Integer minute : JsonUtil.getSortedIntKeySet(minuteToValues)) {
                if (minute > this.options.getMaxRoutingTime()) continue;
                reachablePersons.put(minute, JsonUtil.getDouble(minuteToValues, minute + ""));
            }
            reachablePersonsByStatistic.put(statistic, reachablePersons);
        }
        LOGGER.info(String.format("It took %sms to parse the population results!", System.currentTimeMillis() - start));
        return reachablePersonsByStatistic;
    }

    public Map<Integer, Map<Integer, Double>> getStatistics() {
        return this.statistics;
    }

    public Map<Integer, Integer> getReachableTargets() {
        return this.reachableTargets;
    }

    public Map<Integer, Integer> getTargetTravelTimes() {
        return this.targetTravelTimes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("\n  statistics: \n");
        for (Integer n : this.statistics.keySet()) {
            builder.append("    " + n + "\n");
            builder.append("    ---------------\n");
            for (Map.Entry<Integer, Double> entry : this.statistics.get(n).entrySet()) {
                builder.append("      " + String.format("%6d", entry.getKey()) + ":" + String.format("%14.2f", entry.getValue()) + "\n");
            }
        }
        builder.append("\n  reachableTargets: \n");
        builder.append("  ---------------\n");
        for (Map.Entry entry : this.reachableTargets.entrySet()) {
            builder.append("    " + String.format("%6d", entry.getKey()) + ":" + String.format("%6d", entry.getValue()) + "\n");
        }
        builder.append("\n  targetTravelTimes: \n");
        builder.append("  ---------------\n");
        for (Map.Entry entry : this.targetTravelTimes.entrySet()) {
            builder.append("    " + String.format("%6d", entry.getKey()) + ":" + String.format("%6d", entry.getValue()) + "\n");
        }
        builder.append("}\n");
        return builder.toString();
    }
}

