/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;

public class BaseGraph
implements Serializable {
    private final long networkID;
    protected final TIntObjectMap<double[]> nodes;
    protected final TIntObjectMap<int[]> edges;
    protected final TIntObjectMap<double[][]> supportingPoints;

    public BaseGraph(long networkID) {
        this.networkID = networkID;
        this.nodes = new TIntObjectHashMap();
        this.edges = new TIntObjectHashMap();
        this.supportingPoints = new TIntObjectHashMap();
    }

    public BaseGraph(BaseGraph source) {
        this(source.getNetworkID(), (TIntObjectMap<double[]>)new TIntObjectHashMap(source.getNodes()), (TIntObjectMap<int[]>)new TIntObjectHashMap(source.getEdges()), (TIntObjectMap<double[][]>)new TIntObjectHashMap(source.getSupportingPoints()));
    }

    @JsonCreator
    public BaseGraph(@JsonProperty(value="networkID") long networkID, @JsonProperty(value="nodes") TIntObjectMap<double[]> nodes, @JsonProperty(value="edges") TIntObjectMap<int[]> edges, @JsonProperty(value="supportingPoints") TIntObjectMap<double[][]> supportingPoints) {
        this.networkID = networkID;
        this.nodes = nodes;
        this.edges = edges;
        this.supportingPoints = supportingPoints;
    }

    public long getNetworkID() {
        return this.networkID;
    }

    public TIntObjectMap<double[]> getNodes() {
        return this.nodes;
    }

    public TIntObjectMap<int[]> getEdges() {
        return this.edges;
    }

    public TIntObjectMap<double[][]> getSupportingPoints() {
        return this.supportingPoints;
    }
}

