/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.PointOfInterestResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointOfInterestRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointOfInterestRequest.class);
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public PointOfInterestRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public PointOfInterestRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public PointOfInterestResponse get() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getPointOfInterestServiceUrl()).path("/reachability").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        Entity entity = Entity.entity((Object)RequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug(String.format("Executing reachability request to URI: '%s'", target.getUri()));
        Response response = target.request().post(entity);
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateResponse(response, requestStart, roundTripTime);
    }

    private PointOfInterestResponse validateResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return new PointOfInterestResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), null);
    }
}

