/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum MultiGraphAggregationType {
    NONE("none", false, false, false),
    ONE("one", false, false, false),
    MINIMUM("min", true, false, false),
    MAXIMUM("max", true, false, false),
    SUM("sum", true, false, false),
    MEAN("mean", true, false, false),
    MEDIAN("median", true, false, false),
    NEAREST("nearest", false, false, false),
    COUNT("count", true, false, false),
    ROUTING_UNION("routing_union", false, false, true),
    GRAVITATION_HUFF("gravitation_huff", true, true, false),
    MATH("math", false, false, false);

    private final String key;
    private final boolean mayIgnoreOutliers;
    private final boolean requiresGravitationParameters;
    private final boolean aggregationInRouting;

    private MultiGraphAggregationType(String key, boolean mayIgnoreOutliers, boolean requiresGravitationParameters, boolean aggregationInRouting) {
        this.key = key;
        this.mayIgnoreOutliers = mayIgnoreOutliers;
        this.aggregationInRouting = aggregationInRouting;
        this.requiresGravitationParameters = requiresGravitationParameters;
    }

    @JsonCreator
    public static MultiGraphAggregationType fromString(String key) {
        return key == null ? null : Stream.of(MultiGraphAggregationType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + MultiGraphAggregationType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public boolean isAggregationInRouting() {
        return this.aggregationInRouting;
    }

    @JsonIgnore
    public boolean mayIgnoreOutliers() {
        return this.mayIgnoreOutliers;
    }

    @JsonIgnore
    public boolean requiresGravitationParameters() {
        return this.requiresGravitationParameters;
    }
}

