/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.util;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static int timeToInt(String time) {
        String[] times = time.split(":");
        int hours = Integer.parseInt(times[0]);
        int minutes = Integer.parseInt(times[1]);
        int seconds = Integer.parseInt(times[2]);
        return seconds + minutes * 60 + hours * 3600;
    }

    public static int getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return Integer.valueOf(String.valueOf(year + "" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "" + (day < 10 ? "0" + day : Integer.valueOf(day))));
    }

    public static int getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        return hours * 3600 + minutes * 60 + seconds;
    }

    public static void main(String[] args) {
        System.out.println(TimeUtil.getCurrentDate());
        System.out.println(TimeUtil.getCurrentTime());
    }

    public static String getDurationBreakdown(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Duration must be greater than zero!");
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (days != 0L) {
            sb.append(days);
            sb.append(" Days ");
        }
        if (hours != 0L) {
            sb.append(hours);
            sb.append(" Hours ");
        }
        if (minutes != 0L) {
            sb.append(minutes);
            sb.append(" Minutes ");
        }
        sb.append(seconds);
        sb.append(" Seconds");
        return sb.toString();
    }

    public static Date getToday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TimeUtil.getToday());
        cal.add(6, 1);
        return cal.getTime();
    }

    public static Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        return cal.getTime();
    }
}

