/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.Format;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.PointOfInterestResponse;
import com.targomo.client.api.response.PointOfInterestSummaryResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointOfInterestRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointOfInterestRequest.class);
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public PointOfInterestRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public PointOfInterestRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public PointOfInterestResponse get() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        Response response = this.getResponse("/reachability");
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateResponse(response, requestStart, roundTripTime);
    }

    public PointOfInterestSummaryResponse getSummary() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        Response response = this.getResponse("/reachability/summary");
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateSummaryResponse(response, requestStart, roundTripTime);
    }

    private Response getResponse(String path) throws TargomoClientException {
        WebTarget target = this.client.target(this.travelOptions.getPointOfInterestServiceUrl()).path(path).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        if (this.travelOptions.getFormat() == null) {
            this.travelOptions.setFormat(Format.JSON);
        }
        LOGGER.debug(String.format("Executing reachability request to URI: '%s'", target.getUri()));
        String config = RequestConfigurator.getConfig(this.travelOptions);
        Entity entity = Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        return target.request().post(entity);
    }

    private PointOfInterestResponse validateResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return new PointOfInterestResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }

    private PointOfInterestSummaryResponse validateSummaryResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return new PointOfInterestSummaryResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

