/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum MultiGraphLayerType {
    NODE("node", false, false),
    EDGE("edge", true, false),
    TILE("tile", true, true),
    TILE_NODE("tile_node", false, true),
    HEXAGON("hexagon", true, true),
    HEXAGON_NODE("hexagon_node", false, true);

    private String key;
    private boolean withEdges;
    private boolean isGeometryMerge;

    private MultiGraphLayerType(String key, boolean withEdges, boolean isGeometryMerge) {
        this.key = key;
        this.withEdges = withEdges;
        this.isGeometryMerge = isGeometryMerge;
    }

    @JsonCreator
    public static MultiGraphLayerType fromString(String key) {
        return key == null ? null : Stream.of(MultiGraphLayerType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + MultiGraphLayerType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public boolean isWithEdges() {
        return this.withEdges;
    }

    @JsonIgnore
    public boolean isGeometryMerge() {
        return this.isGeometryMerge;
    }
}

