/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.response.OverpassResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverpassRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OverpassRequest.class);
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public OverpassRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public OverpassRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public OverpassResponse get() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getOverpassServiceUrl()).path("/api/interpreter");
        LOGGER.info(String.format("%s", target.getUri()));
        if (this.travelOptions.getOverpassQuery() == null || this.travelOptions.getOverpassQuery().isEmpty()) {
            throw new TargomoClientException("Empty query");
        }
        Entity entity = Entity.entity((Object)this.travelOptions.getOverpassQuery(), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug(String.format("Executing overpass query to URI: '%s'", target.getUri()));
        Response response = target.request().post(entity);
        return this.validateResponse(response, requestStart);
    }

    private OverpassResponse validateResponse(Response response, long requestStart) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return new OverpassResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), null);
    }
}

