/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.targomo.client.api.geo.DefaultTargetCoordinate;
import com.targomo.client.api.response.esri.Candidate;
import com.targomo.client.api.response.esri.ErrorDescription;
import com.targomo.client.api.util.POJOUtil;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.boon.json.JsonFactory;
import org.boon.json.ObjectMapper;

public class GeocodingResponse
implements Iterable<Candidate> {
    private static final ObjectMapper JSON_PARSER = JsonFactory.create();
    private final List<Candidate> candidates;
    private final ErrorDescription error;
    private final String completeJsonResponse;

    private GeocodingResponse(List<Candidate> candidates, ErrorDescription error, String jsonString) {
        this.completeJsonResponse = jsonString;
        this.error = error;
        this.candidates = candidates;
    }

    public static GeocodingResponse createFromJson(String jsonString) {
        GeocodingResponse ret = (GeocodingResponse)JSON_PARSER.fromJson(jsonString, GeocodingResponse.class);
        return new GeocodingResponse(ret.candidates, ret.error, jsonString);
    }

    public ErrorDescription getError() {
        return this.error;
    }

    public boolean wasErrorResponse() {
        return this.error != null;
    }

    public String getCompleteJsonResponseAsString() {
        return this.completeJsonResponse;
    }

    public DefaultTargetCoordinate getRepresentativeGeocodeOfRequest() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            throw new NoSuchElementException("This response does not contain a coordination candidate.");
        }
        Candidate mostLikelyCandidate = this.candidates.get(0);
        return mostLikelyCandidate.getLocation();
    }

    public Candidate getRepresentativeCandidate() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            throw new NoSuchElementException("This response does not contain a candidate.");
        }
        return this.candidates.get(0);
    }

    public String toString() {
        return POJOUtil.prettyPrintPOJO(this);
    }

    @Override
    public Iterator<Candidate> iterator() {
        return this.candidates.iterator();
    }

    public boolean isEmpty() {
        return this.candidates == null || this.candidates.isEmpty();
    }
}

