/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.request.config.builder.JSONBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RequestConfigurator {
    private static final Logger LOG = Logger.getLogger(RequestConfigurator.class);

    private RequestConfigurator() {
    }

    public static String getConfig(TravelOptions travelOptions) throws TargomoClientException {
        LOG.trace((Object)"Creating configuration...");
        String config = RequestConfigurator.getCommonConfig(travelOptions);
        LOG.trace((Object)"Configuration created.");
        return config;
    }

    private static String getCommonConfig(TravelOptions travelOptions) throws TargomoClientException {
        StringBuilder config = JSONBuilder.beginJson(new StringBuilder());
        try {
            if (travelOptions.getTravelTimes() != null && !travelOptions.getTravelTimes().isEmpty()) {
                JSONBuilder.append(config, "polygon", RequestConfigurator.getPolygonObject(travelOptions));
            }
            if (Stream.of(new Object[]{travelOptions.getMultiGraphEdgeClasses(), travelOptions.getMultiGraphSerializationFormat(), travelOptions.getMultiGraphSerializationDecimalPrecision(), travelOptions.getMultiGraphAggregationType(), travelOptions.getMultiGraphAggregationIgnoreOutlier(), travelOptions.getMultiGraphAggregationOutlierPenalty(), travelOptions.getMultiGraphAggregationMinSourcesCount(), travelOptions.getMultiGraphAggregationMinSourcesRatio(), travelOptions.getMultiGraphAggregationMaxResultValue(), travelOptions.getMultiGraphAggregationMaxResultValueRatio(), travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins(), travelOptions.getMultiGraphLayerType(), travelOptions.getMultiGraphLayerEdgeAggregationType()}).anyMatch(Objects::nonNull) || Stream.of(travelOptions.getMultiGraphTileZoom(), travelOptions.getMultiGraphTileX(), travelOptions.getMultiGraphTileY()).allMatch(Objects::nonNull)) {
                JSONBuilder.append(config, "multigraph", RequestConfigurator.getMultiGraphObject(travelOptions));
            }
            if (travelOptions.getIntersectionMode() != null) {
                JSONBuilder.appendString(config, "intersectionMode", (Object)travelOptions.getIntersectionMode());
            }
            if (travelOptions.getSources() != null && !travelOptions.getSources().isEmpty()) {
                JSONBuilder.append(config, "sources", RequestConfigurator.getSources(travelOptions));
            }
            if (travelOptions.getTargets() != null && !travelOptions.getTargets().isEmpty()) {
                JSONBuilder.append(config, "targets", RequestConfigurator.getTargets(travelOptions));
            }
            if (travelOptions.getPathSerializer() != null) {
                JSONBuilder.appendString(config, "pathSerializer", travelOptions.getPathSerializer().getPathSerializerName());
            }
            if (travelOptions.isElevationEnabled() != null) {
                JSONBuilder.append(config, "elevation", travelOptions.isElevationEnabled());
            }
            if (travelOptions.getReverse() != null) {
                JSONBuilder.append(config, "reverse", travelOptions.getReverse());
            }
            if (travelOptions.getEdgeWeightType() != null) {
                JSONBuilder.appendString(config, "edgeWeight", (Object)travelOptions.getEdgeWeightType());
            }
            if (travelOptions.getStatisticGroupId() != null) {
                JSONBuilder.appendString(config, "statisticGroupId", travelOptions.getStatisticGroupId());
            }
            if (travelOptions.getStatisticIds() != null) {
                JSONBuilder.append(config, "statistics", travelOptions.getStatisticIds());
            }
            if (travelOptions.getServiceUrl() != null) {
                JSONBuilder.append(config, "serviceUrl", "\"" + travelOptions.getServiceUrl() + "\"");
            }
            if (travelOptions.getServiceKey() != null) {
                JSONBuilder.append(config, "serviceKey", "\"" + travelOptions.getServiceKey() + "\"");
            }
            if (travelOptions.getFormat() != null) {
                JSONBuilder.append(config, "format", "\"" + travelOptions.getFormat().toString().toLowerCase() + "\"");
            }
            if (travelOptions.getBoundingBox() != null) {
                JSONBuilder.append(config, "boundingBox", "\"" + travelOptions.getBoundingBox() + "\"");
            }
            if (travelOptions.getOsmTypes() != null) {
                ObjectMapper mapper = new ObjectMapper();
                JSONBuilder.append(config, "osmTypes", mapper.writeValueAsString(travelOptions.getOsmTypes()));
            }
            if (travelOptions.getTravelTimeFactors() != null && !travelOptions.getTravelTimeFactors().isEmpty()) {
                JSONObject travelFactors = new JSONObject();
                for (Map.Entry<String, Double> factor : travelOptions.getTravelTimeFactors().entrySet()) {
                    travelFactors.put(factor.getKey(), (Object)factor.getValue());
                }
                JSONBuilder.append(config, "travelTimeFactors", travelFactors);
            }
            JSONBuilder.append(config, "onlyPrintReachablePoints", travelOptions.getOnlyPrintReachablePoints());
            JSONBuilder.appendAndEnd(config, "maxEdgeWeight", travelOptions.getMaxEdgeWeight());
        }
        catch (Exception e) {
            throw new TargomoClientException("Could not generate targomo config object", e);
        }
        return config.toString();
    }

    private static JSONObject getPolygonObject(TravelOptions travelOptions) throws JSONException {
        JSONObject polygon = new JSONObject();
        polygon.put("values", (Object)new JSONArray(travelOptions.getTravelTimes()));
        polygon.put("intersectionMode", (Object)travelOptions.getIntersectionMode());
        polygon.put("pointReduction", travelOptions.isPointReduction());
        polygon.put("minPolygonHoleSize", travelOptions.getMinPolygonHoleSize());
        if (travelOptions.getSrid() != null) {
            polygon.put("srid", (Object)travelOptions.getSrid());
        }
        if (travelOptions.getDecimalPrecision() != null) {
            polygon.put("decimalPrecision", (Object)travelOptions.getDecimalPrecision());
        }
        if (travelOptions.getBuffer() != null) {
            polygon.put("buffer", (Object)travelOptions.getBuffer());
        }
        if (travelOptions.getSimplify() != null) {
            polygon.put("simplify", (Object)travelOptions.getSimplify());
        }
        if (travelOptions.getPolygonSerializerType() != null) {
            polygon.put("serializer", (Object)travelOptions.getPolygonSerializerType().getPolygonSerializerName());
        }
        if (travelOptions.getIntersectionGeometry() != null) {
            JSONObject intersectionPolygon = new JSONObject();
            intersectionPolygon.put("crs", (Object)travelOptions.getIntersectionGeometry().getCrs());
            intersectionPolygon.put("data", (Object)travelOptions.getIntersectionGeometry().getData());
            intersectionPolygon.put("type", (Object)travelOptions.getIntersectionGeometry().getType());
            polygon.put("intersectionGeometry", (Object)intersectionPolygon);
        }
        return polygon;
    }

    private static JSONObject getMultiGraphObject(TravelOptions travelOptions) throws JSONException {
        JSONObject multiGraph = new JSONObject();
        if (travelOptions.getMultiGraphEdgeClasses() != null) {
            multiGraph.put("edgeClasses", travelOptions.getMultiGraphEdgeClasses());
        }
        RequestConfigurator.addMultiGraphLayer(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphTile(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphSerialization(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphAggregation(travelOptions, multiGraph);
        return multiGraph;
    }

    private static void addMultiGraphLayer(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(new Serializable[]{travelOptions.getMultiGraphLayerType(), travelOptions.getMultiGraphLayerEdgeAggregationType(), travelOptions.getMultiGraphLayerGeometryDetailPerTile(), travelOptions.getMultiGraphLayerMinGeometryDetailLevel(), travelOptions.getMultiGraphLayerMaxGeometryDetailLevel(), travelOptions.getMultiGraphLayerGeometryDetailLevel()}).anyMatch(Objects::nonNull)) {
            JSONObject multigraphLayer = new JSONObject();
            if (travelOptions.getMultiGraphSerializationFormat() != null) {
                multigraphLayer.put("type", (Object)travelOptions.getMultiGraphLayerType().getKey());
            }
            if (travelOptions.getMultiGraphLayerEdgeAggregationType() != null) {
                multigraphLayer.put("edgeAggregationType", (Object)travelOptions.getMultiGraphLayerEdgeAggregationType().getKey());
            }
            if (travelOptions.getMultiGraphLayerGeometryDetailPerTile() != null) {
                multigraphLayer.put("geometryDetailPerTile", (Object)travelOptions.getMultiGraphLayerGeometryDetailPerTile());
            }
            if (travelOptions.getMultiGraphLayerMinGeometryDetailLevel() != null) {
                multigraphLayer.put("minGeometryDetailLevel", (Object)travelOptions.getMultiGraphLayerMinGeometryDetailLevel());
            }
            if (travelOptions.getMultiGraphLayerMaxGeometryDetailLevel() != null) {
                multigraphLayer.put("maxGeometryDetailLevel", (Object)travelOptions.getMultiGraphLayerMaxGeometryDetailLevel());
            }
            if (travelOptions.getMultiGraphLayerGeometryDetailLevel() != null) {
                multigraphLayer.put("geometryDetailLevel", (Object)travelOptions.getMultiGraphLayerGeometryDetailLevel());
            }
            multiGraph.put("layer", (Object)multigraphLayer);
        }
    }

    private static void addMultiGraphTile(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(travelOptions.getMultiGraphTileZoom(), travelOptions.getMultiGraphTileX(), travelOptions.getMultiGraphTileY()).allMatch(Objects::nonNull)) {
            JSONObject multigraphTile = new JSONObject();
            multigraphTile.put("zoom", (Object)travelOptions.getMultiGraphTileZoom());
            multigraphTile.put("x", (Object)travelOptions.getMultiGraphTileX());
            multigraphTile.put("y", (Object)travelOptions.getMultiGraphTileY());
            multiGraph.put("tile", (Object)multigraphTile);
        } else if (Stream.of(travelOptions.getMultiGraphTileZoom(), travelOptions.getMultiGraphTileX(), travelOptions.getMultiGraphTileY()).anyMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("None or all elements in the tile definition have to be set.");
        }
    }

    private static void addMultiGraphSerialization(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(new Serializable[]{travelOptions.getMultiGraphSerializationFormat(), travelOptions.getMultiGraphSerializationDecimalPrecision()}).anyMatch(Objects::nonNull)) {
            JSONObject multigraphSerialization = new JSONObject();
            if (travelOptions.getMultiGraphSerializationFormat() != null) {
                multigraphSerialization.put("format", (Object)travelOptions.getMultiGraphSerializationFormat().getKey());
            }
            if (travelOptions.getMultiGraphSerializationDecimalPrecision() != null) {
                multigraphSerialization.put("decimalPrecision", (Object)travelOptions.getMultiGraphSerializationDecimalPrecision());
            }
            if (travelOptions.getMultiGraphSerializationDecimalPrecision() != null) {
                multigraphSerialization.put("maxGeometryCount", (Object)travelOptions.getMultiGraphSerializationMaxGeometryCount());
            }
            multiGraph.put("serialization", (Object)multigraphSerialization);
        }
    }

    private static void addMultiGraphAggregation(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(new Object[]{travelOptions.getMultiGraphAggregationType(), travelOptions.getMultiGraphAggregationIgnoreOutlier(), travelOptions.getMultiGraphAggregationOutlierPenalty(), travelOptions.getMultiGraphAggregationMinSourcesCount(), travelOptions.getMultiGraphAggregationMinSourcesRatio(), travelOptions.getMultiGraphAggregationMaxResultValue(), travelOptions.getMultiGraphAggregationMaxResultValueRatio(), travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins()}).anyMatch(Objects::nonNull)) {
            JSONObject multigraphAggregation = new JSONObject();
            if (travelOptions.getMultiGraphAggregationType() != null) {
                multigraphAggregation.put("type", (Object)travelOptions.getMultiGraphAggregationType().getKey());
            }
            if (travelOptions.getMultiGraphAggregationIgnoreOutlier() != null) {
                multigraphAggregation.put("ignoreOutliers", (Object)travelOptions.getMultiGraphAggregationIgnoreOutlier());
            }
            if (travelOptions.getMultiGraphAggregationOutlierPenalty() != null) {
                multigraphAggregation.put("outlierPenalty", (Object)travelOptions.getMultiGraphAggregationOutlierPenalty());
            }
            if (travelOptions.getMultiGraphAggregationMinSourcesCount() != null) {
                multigraphAggregation.put("minSourcesCount", (Object)travelOptions.getMultiGraphAggregationMinSourcesCount());
            }
            if (travelOptions.getMultiGraphAggregationMinSourcesRatio() != null) {
                multigraphAggregation.put("minSourcesRatio", (Object)travelOptions.getMultiGraphAggregationMinSourcesRatio());
            }
            if (travelOptions.getMultiGraphAggregationMaxResultValueRatio() != null) {
                multigraphAggregation.put("maxResultValueRatio", (Object)travelOptions.getMultiGraphAggregationMaxResultValueRatio());
            }
            if (travelOptions.getMultiGraphAggregationMaxResultValue() != null) {
                multigraphAggregation.put("maxResultValue", (Object)travelOptions.getMultiGraphAggregationMaxResultValue());
            }
            if (travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins() != null) {
                multigraphAggregation.put("filterValuesForSourceOrigins", travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins());
            }
            multiGraph.put("aggregation", (Object)multigraphAggregation);
        }
    }

    private static JSONArray getSources(TravelOptions travelOptions) throws JSONException {
        JSONArray sources = new JSONArray();
        for (Coordinate src : travelOptions.getSources().values()) {
            JSONObject source = RequestConfigurator.getSourceObject(travelOptions, src);
            sources.put((Object)source);
        }
        return sources;
    }

    private static StringBuilder getTargets(TravelOptions travelOptions) {
        StringBuilder targetsBuilder = new StringBuilder().append("[");
        for (Coordinate trg : travelOptions.getTargets().values()) {
            RequestConfigurator.buildTarget(targetsBuilder, trg).append(",");
        }
        targetsBuilder.deleteCharAt(targetsBuilder.length() - 1);
        targetsBuilder.append("]");
        return targetsBuilder;
    }

    private static StringBuilder buildTarget(StringBuilder targetsBuilder, Coordinate trg) {
        JSONBuilder.beginJson(targetsBuilder);
        JSONBuilder.appendString(targetsBuilder, "id", trg.getId());
        JSONBuilder.append(targetsBuilder, "lat", trg.getY());
        JSONBuilder.appendAndEnd(targetsBuilder, "lng", trg.getX());
        return targetsBuilder;
    }

    private static JSONObject getTravelMode(TravelOptions travelOptions, TravelType travelType) throws JSONException {
        JSONObject travelMode = new JSONObject();
        switch (travelType) {
            case TRANSIT: {
                travelMode.put("frame", (Object)new JSONObject().put("time", travelOptions.getTime()).put("date", travelOptions.getDate()).put("duration", travelOptions.getFrame()));
                if (travelOptions.getMaxTransfers() != null && travelOptions.getMaxTransfers() >= 0) {
                    travelMode.put("maxTransfers", (Object)travelOptions.getMaxTransfers());
                }
                travelMode.put("recommendations", travelOptions.getRecommendations());
                travelMode.put("speed", travelOptions.getWalkSpeed());
                travelMode.put("uphill", travelOptions.getWalkUphill());
                travelMode.put("downhill", travelOptions.getWalkDownhill());
                break;
            }
            case WALK: {
                travelMode.put("speed", travelOptions.getWalkSpeed());
                travelMode.put("uphill", travelOptions.getWalkUphill());
                travelMode.put("downhill", travelOptions.getWalkDownhill());
                break;
            }
            case BIKE: {
                travelMode.put("speed", travelOptions.getBikeSpeed());
                travelMode.put("uphill", travelOptions.getBikeUphill());
                travelMode.put("downhill", travelOptions.getBikeDownhill());
                break;
            }
            case CAR: {
                travelMode.put("rushHour", travelOptions.getRushHour());
                break;
            }
        }
        return travelMode;
    }

    private static TravelType getTravelType(TravelOptions travelOptions, Coordinate src) {
        TravelType travelType = travelOptions.getTravelType();
        if (src.getTravelType() != null && src.getTravelType() != travelType && src.getTravelType() != TravelType.UNSPECIFIED) {
            travelType = src.getTravelType();
        }
        return travelType;
    }

    private static JSONObject getSourceObject(TravelOptions travelOptions, Coordinate src) throws JSONException {
        TravelType travelType = RequestConfigurator.getTravelType(travelOptions, src);
        JSONObject travelMode = RequestConfigurator.getTravelMode(travelOptions, travelType);
        JSONObject source = new JSONObject().put("id", (Object)src.getId()).put("lat", src.getY()).put("lng", src.getX()).put("tm", (Object)new JSONObject().put(travelType.toString(), (Object)travelMode));
        if (travelOptions.getReverse() != null) {
            source.put("reverse", (Object)travelOptions.getReverse());
        }
        return source;
    }
}

