/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.request.ssl.SslClientGenerator;
import com.targomo.client.api.response.DefaultResponse;
import com.targomo.client.api.util.IOUtil;
import java.io.IOException;
import java.util.function.BiFunction;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class TargomoRequest<R extends DefaultResponse<?, ?>> {
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CALLBACK = "callback";
    private final Class<R> clazz;
    private final String httpMethod;
    private final String path;
    private final Client client;
    private final TravelOptions travelOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <O extends DefaultResponse<?, ?>, C extends TargomoRequest<O>> O executeRequest(BiFunction<Client, TravelOptions, C> constructor, TravelOptions travelOptions) throws TargomoClientException {
        try (Client client = SslClientGenerator.initClient();){
            Object r = ((TargomoRequest)constructor.apply(client, travelOptions)).get();
            return (O)r;
        }
    }

    TargomoRequest(Client client, TravelOptions travelOptions, String path, String httpMethod, Class<R> clazz) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.path = path;
        this.httpMethod = httpMethod;
        this.clazz = clazz;
    }

    public String toCurl() throws TargomoClientException {
        String url = this.travelOptions.getServiceUrl().endsWith("/") ? this.travelOptions.getServiceUrl() : this.travelOptions.getServiceUrl() + "/";
        return "curl -X " + this.httpMethod + " '" + url + this.path + "?cb=" + CALLBACK + "&key=" + this.travelOptions.getServiceKey() + "' -H 'content-type: application/json' -d '" + RequestConfigurator.getConfig(this.travelOptions) + "'";
    }

    public R get() throws TargomoClientException {
        Response response;
        long startTimeMillis = System.currentTimeMillis();
        WebTarget request = this.client.target(this.travelOptions.getServiceUrl()).path(this.path).queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        String config = RequestConfigurator.getConfig(this.travelOptions);
        if ("GET".equals(this.httpMethod)) {
            request = request.queryParam("cfg", new Object[]{IOUtil.encode(config)});
            response = request.request().get();
        } else if ("POST".equals(this.httpMethod)) {
            response = request.request().post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        } else {
            throw new TargomoClientException("HTTP Method not supported: " + this.httpMethod);
        }
        return this.validateResponse(response, System.currentTimeMillis() - startTimeMillis);
    }

    private R validateResponse(Response response, long roundTripTimeMillis) throws TargomoClientException {
        long startParsing;
        DefaultResponse parsedResponse;
        block6: {
            parsedResponse = null;
            startParsing = System.currentTimeMillis();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                String resultString = IOUtil.getResultString(response);
                try {
                    parsedResponse = (DefaultResponse)MAPPER.readValue(resultString, this.clazz);
                    String responseCode = parsedResponse.getCode();
                    if ("no-route-found".equals(responseCode) || "could-not-connect-point-to-network".equals(responseCode) || "travel-time-exceeded".equals(responseCode) || "unknown-exception".equals(responseCode)) {
                        throw new TargomoClientException(resultString, null);
                    }
                    break block6;
                }
                catch (IOException e) {
                    throw new TargomoClientException("Exception occurred for result: " + resultString, e);
                }
            }
            if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
                parsedResponse = (DefaultResponse)DefaultResponse.createGatewayTimeoutResponse(this.clazz);
            }
        }
        if (parsedResponse != null) {
            parsedResponse.finishDeserialization(this.travelOptions, roundTripTimeMillis, System.currentTimeMillis() - startParsing);
            return (R)parsedResponse;
        }
        throw new TargomoClientException("Status: " + response.getStatus() + ": " + (String)response.readEntity(String.class), null);
    }
}

