/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.targomo.client.api.enums.EdgeWeightType;
import com.targomo.client.api.enums.Format;
import com.targomo.client.api.enums.MultiGraphAggregationType;
import com.targomo.client.api.enums.MultiGraphLayerEdgeAggregationType;
import com.targomo.client.api.enums.MultiGraphLayerType;
import com.targomo.client.api.enums.MultiGraphSerializationFormat;
import com.targomo.client.api.enums.PathSerializerType;
import com.targomo.client.api.enums.PolygonIntersectionMode;
import com.targomo.client.api.enums.PolygonSerializerType;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.geo.DefaultSourceCoordinate;
import com.targomo.client.api.geo.DefaultTargetCoordinate;
import com.targomo.client.api.json.DefaultSourceCoordinateMapDeserializer;
import com.targomo.client.api.json.DefaultSourceCoordinateMapSerializer;
import com.targomo.client.api.json.DefaultTargetCoordinateMapDeserializer;
import com.targomo.client.api.json.DefaultTargetCoordinateMapSerializer;
import com.targomo.client.api.pojo.Geometry;
import com.targomo.client.api.request.config.multigraph.AggregationConfig;
import com.targomo.client.api.request.config.multigraph.SourceParameter;
import com.targomo.client.api.statistic.PoiType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="travel_option")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class TravelOptions
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private Integer id;
    @JsonDeserialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapSerializer.class)
    @Transient
    private Map<String, Coordinate> sources = new HashMap<String, Coordinate>();
    @JsonDeserialize(contentAs=DefaultTargetCoordinate.class, using=DefaultTargetCoordinateMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceCoordinate.class, using=DefaultTargetCoordinateMapSerializer.class)
    @Transient
    private Map<String, Coordinate> targets = new HashMap<String, Coordinate>();
    @Column(name="bike_speed")
    private double bikeSpeed = 15.0;
    @Column(name="bike_uphill")
    private double bikeUphill = 20.0;
    @Column(name="bike_downhill")
    private double bikeDownhill = -10.0;
    @Column(name="walk_speed")
    private double walkSpeed = 5.0;
    @Column(name="walk_uphill")
    private double walkUphill = 10.0;
    @Column(name="walk_downhill")
    private double walkDownhill = 0.0;
    @Column(name="rush_hour")
    private Boolean rushHour = false;
    @Transient
    private Integer trafficJunctionPenalty = null;
    @Transient
    private Integer trafficSignalPenalty = null;
    @Transient
    private List<Integer> travelTimes = Arrays.asList(600, 1200, 1800);
    @Column(name="travel_type")
    private TravelType travelType = TravelType.UNSPECIFIED;
    @Transient
    private Map<String, Double> travelTimeFactors = new HashMap<String, Double>();
    @Column(name="elevation_enabled")
    private Boolean elevationEnabled = false;
    @Transient
    private Boolean appendTravelTimes = false;
    @Transient
    private Boolean pointReduction = true;
    @Transient
    private Boolean reverse = false;
    @Transient
    private Long minPolygonHoleSize = 100000000L;
    @Column(name="time")
    private Integer time = 32400;
    @Column(name="date")
    private Integer date = 20170214;
    @Column(name="frame")
    private Integer frame = 18000;
    @Transient
    private Integer maxWalkingTimeFromSource = null;
    @Transient
    private Integer maxWalkingTimeToTarget = null;
    @Transient
    private Integer recommendations = 0;
    @Transient
    private Integer srid = null;
    @Transient
    private Integer decimalPrecision = null;
    @Column(name="max_transfers")
    private Integer maxTransfers = null;
    @Transient
    private List<Integer> avoidTransitRouteTypes = Collections.emptyList();
    @Transient
    private Double buffer = null;
    @Transient
    private Double simplify = null;
    @Transient
    private PolygonIntersectionMode intersectionMode = PolygonIntersectionMode.UNION;
    @Transient
    private PathSerializerType pathSerializer = PathSerializerType.COMPACT_PATH_SERIALIZER;
    @Transient
    private PolygonSerializerType polygonSerializerType = PolygonSerializerType.JSON_POLYGON_SERIALIZER;
    @Transient
    private Set<Integer> multiGraphEdgeClasses = null;
    @Transient
    private MultiGraphSerializationFormat multiGraphSerializationFormat = null;
    @Transient
    private Integer multiGraphSerializationDecimalPrecision = null;
    @Transient
    private Integer multiGraphSerializationMaxGeometryCount = null;
    @Transient
    private MultiGraphAggregationType multiGraphAggregationType = null;
    @Transient
    private Boolean multiGraphAggregationIgnoreOutlier = null;
    @Transient
    private Integer multiGraphAggregationOutlierPenalty = null;
    @Transient
    private Double multiGraphAggregationMinSourcesRatio = null;
    @Transient
    private Integer multiGraphAggregationMinSourcesCount = null;
    @Transient
    private Double multiGraphAggregationMaxResultValueRatio = null;
    @Transient
    private Integer multiGraphAggregationMaxResultValue = null;
    @Transient
    private Set<String> multiGraphAggregationFilterValuesForSourceOrigins = null;
    @Transient
    private Map<String, SourceParameter> multiGraphSourceParameters = null;
    @Transient
    private Map<String, AggregationConfig> multiGraphPreAggregationPipeline = null;
    @Transient
    private MultiGraphLayerType multiGraphLayerType = null;
    @Transient
    private MultiGraphLayerEdgeAggregationType multiGraphLayerEdgeAggregationType = null;
    @Transient
    private Integer multiGraphLayerGeometryDetailPerTile = null;
    @Transient
    private Integer multiGraphLayerMinGeometryDetailLevel = null;
    @Transient
    private Integer multiGraphLayerMaxGeometryDetailLevel = null;
    @Transient
    private Integer multiGraphLayerGeometryDetailLevel = null;
    @Transient
    private Integer multiGraphTileZoom = null;
    @Transient
    private Integer multiGraphTileX = null;
    @Transient
    private Integer multiGraphTileY = null;
    @Column(name="max_edge_weight")
    private Integer maxEdgeWeight = 1800;
    @Column(name="service_url")
    private String serviceUrl = "";
    @Column(name="fallback_service_url")
    private String fallbackServiceUrl = "";
    @Column(name="service_key")
    private String serviceKey = "";
    @Transient
    private boolean onlyPrintReachablePoints = true;
    @JsonProperty(value="edgeWeight")
    @Column(name="edge_weight_type")
    private EdgeWeightType edgeWeightType = EdgeWeightType.TIME;
    @Transient
    private List<Short> statisticIds;
    @Column(name="statistic_group_id")
    private Integer statisticGroupId;
    @Column(name="statistic_service_url")
    private String statisticServiceUrl = "https://api.targomo.com/statistics/";
    @Column(name="poi_service_url")
    private String pointOfInterestServiceUrl = "https://api.targomo.com/pointsofinterest/";
    @Column(name="overpass_query")
    private String overpassQuery;
    @Column(name="overpass_service_url")
    private String overpassServiceUrl = "https://api.targomo.com/overpass/";
    @Column(name="inter_service_key")
    private String interServiceKey = "";
    @Transient
    private Format format;
    @Transient
    private Geometry intersectionGeometry;
    @Transient
    private String boundingBox;
    @Transient
    private Set<TravelType> travelTypes = new HashSet<TravelType>();
    @Transient
    private Set<PoiType> osmTypes = new HashSet<PoiType>();
    @Transient
    private Set<PoiType> customPois = new HashSet<PoiType>();
    @Transient
    private boolean disableCache;

    public String getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(String boundingBox) {
        this.boundingBox = boundingBox;
    }

    public Set<PoiType> getCustomPois() {
        return this.customPois;
    }

    public void setCustomPois(Set<PoiType> customPois) {
        this.customPois = customPois;
    }

    public Set<TravelType> getTravelTypes() {
        return this.travelTypes;
    }

    public void setTravelTypes(Set<TravelType> travelTypes) {
        this.travelTypes = travelTypes;
    }

    public Set<PoiType> getOsmTypes() {
        return this.osmTypes;
    }

    public void setOsmTypes(Set<PoiType> osmTypes) {
        this.osmTypes = osmTypes;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @JsonIgnore
    public double[][] getSourceCoordinates() {
        return this.getCoordinates(this.sources);
    }

    @JsonIgnore
    public double[][] getTargetCoordinates() {
        return this.getCoordinates(this.targets);
    }

    private double[][] getCoordinates(Map<String, Coordinate> points) {
        Coordinate[] pointList = points.values().toArray(new Coordinate[0]);
        double[][] coordinates = new double[points.size()][];
        for (int i = 0; i < points.size(); ++i) {
            coordinates[i] = new double[]{pointList[i].getX(), pointList[i].getY()};
        }
        return coordinates;
    }

    public Map<String, Coordinate> getSources() {
        return this.sources;
    }

    public void setSources(Map<String, Coordinate> sources) {
        this.sources = sources;
    }

    public Map<String, Coordinate> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, Coordinate> targets) {
        this.targets = targets;
    }

    public void addAllTargets(Map<String, Coordinate> targets) {
        this.targets.putAll(targets);
    }

    public void addAllTargets(Collection<Coordinate> targets) {
        this.targets = targets.stream().collect(Collectors.toMap(t -> t.getId(), Function.identity()));
    }

    public double getBikeSpeed() {
        return this.bikeSpeed;
    }

    public void setBikeSpeed(double bikeSpeed) {
        this.bikeSpeed = bikeSpeed;
    }

    public double getBikeUphill() {
        return this.bikeUphill;
    }

    public void setBikeUphill(double bikeUphill) {
        this.bikeUphill = bikeUphill;
    }

    public double getBikeDownhill() {
        return this.bikeDownhill;
    }

    public void setBikeDownhill(double bikeDownhill) {
        this.bikeDownhill = bikeDownhill;
    }

    public Integer getTrafficJunctionPenalty() {
        return this.trafficJunctionPenalty;
    }

    public void setTrafficJunctionPenalty(Integer trafficJunctionPenalty) {
        this.trafficJunctionPenalty = trafficJunctionPenalty;
    }

    public Integer getTrafficSignalPenalty() {
        return this.trafficSignalPenalty;
    }

    public void setTrafficSignalPenalty(Integer trafficSignalPenalty) {
        this.trafficSignalPenalty = trafficSignalPenalty;
    }

    public double getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setWalkSpeed(double walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public double getWalkUphill() {
        return this.walkUphill;
    }

    public void setWalkUphill(double walkUphill) {
        this.walkUphill = walkUphill;
    }

    public double getWalkDownhill() {
        return this.walkDownhill;
    }

    public void setWalkDownhill(double walkDownhill) {
        this.walkDownhill = walkDownhill;
    }

    public void setRushHour(boolean rushHourEnabled) {
        this.rushHour = rushHourEnabled;
    }

    public boolean getRushHour() {
        return this.rushHour;
    }

    public List<Integer> getTravelTimes() {
        return this.travelTimes;
    }

    public void setTravelTimes(List<Integer> travelTimes) {
        this.travelTimes = travelTimes;
    }

    public TravelType getTravelType() {
        return this.travelType;
    }

    public void setTravelType(TravelType travelType) {
        this.travelType = travelType;
    }

    public Boolean isElevationEnabled() {
        return this.elevationEnabled;
    }

    public void setElevationEnabled(Boolean elevationEnabled) {
        this.elevationEnabled = elevationEnabled;
    }

    public long getMinPolygonHoleSize() {
        return this.minPolygonHoleSize;
    }

    public void setMinPolygonHoleSize(long minPolygonHoleSize) {
        this.minPolygonHoleSize = minPolygonHoleSize;
    }

    public Integer getTime() {
        return this.time;
    }

    public void setTime(Integer time) {
        this.time = time;
    }

    public Integer getDate() {
        return this.date;
    }

    public void setDate(Integer date) {
        this.date = date;
    }

    public Integer getFrame() {
        return this.frame;
    }

    public void setFrame(Integer frame) {
        this.frame = frame;
    }

    public Integer getMaxWalkingTimeFromSource() {
        return this.maxWalkingTimeFromSource;
    }

    public void setMaxWalkingTimeFromSource(Integer maxWalkingTimeFromSource) {
        this.maxWalkingTimeFromSource = maxWalkingTimeFromSource;
    }

    public Integer getMaxWalkingTimeToTarget() {
        return this.maxWalkingTimeToTarget;
    }

    public void setMaxWalkingTimeToTarget(Integer maxWalkingTimeToTarget) {
        this.maxWalkingTimeToTarget = maxWalkingTimeToTarget;
    }

    public int getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(int recommendations) {
        this.recommendations = recommendations;
    }

    public PolygonIntersectionMode getIntersectionMode() {
        return this.intersectionMode;
    }

    public void setIntersectionMode(PolygonIntersectionMode intersectionMode) {
        this.intersectionMode = intersectionMode;
    }

    public PathSerializerType getPathSerializer() {
        return this.pathSerializer;
    }

    public void setPathSerializer(PathSerializerType pathSerializer) {
        this.pathSerializer = pathSerializer;
    }

    public PolygonSerializerType getPolygonSerializerType() {
        return this.polygonSerializerType;
    }

    public void setPolygonSerializerType(PolygonSerializerType polygonSerializerType) {
        this.polygonSerializerType = polygonSerializerType;
    }

    public boolean isPointReduction() {
        return this.pointReduction;
    }

    public void setPointReduction(boolean pointReduction) {
        this.pointReduction = pointReduction;
    }

    @JsonIgnore
    @Deprecated
    public int getMaxRoutingTime() {
        if (this.edgeWeightType == EdgeWeightType.TIME) {
            return this.maxEdgeWeight;
        }
        return 0;
    }

    @JsonIgnore
    @Deprecated
    public void setMaxRoutingTime(int maxRoutingTime) {
        this.maxEdgeWeight = maxRoutingTime;
        this.edgeWeightType = EdgeWeightType.TIME;
    }

    @JsonIgnore
    @Deprecated
    public Integer getMaxRoutingLength() {
        if (this.edgeWeightType == EdgeWeightType.DISTANCE) {
            return this.maxEdgeWeight;
        }
        return 0;
    }

    @JsonIgnore
    @Deprecated
    public void setMaxRoutingLength(Integer maxRoutingLength) {
        this.maxEdgeWeight = maxRoutingLength;
        this.edgeWeightType = EdgeWeightType.DISTANCE;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public void addSource(Coordinate source) {
        this.sources.put(source.getId(), source);
    }

    public void addTarget(Coordinate target) {
        this.targets.put(target.getId(), target);
    }

    public Map<String, SourceParameter> getMultiGraphSourceParameters() {
        return this.multiGraphSourceParameters;
    }

    public void setMultiGraphSourceParameters(Map<String, SourceParameter> multiGraphSourceParameters) {
        this.multiGraphSourceParameters = multiGraphSourceParameters;
    }

    public Map<String, AggregationConfig> getMultiGraphPreAggregationPipeline() {
        return this.multiGraphPreAggregationPipeline;
    }

    public void setMultiGraphPreAggregationPipeline(Map<String, AggregationConfig> multiGraphPreAggregationPipeline) {
        this.multiGraphPreAggregationPipeline = multiGraphPreAggregationPipeline;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TravelOptions)) {
            return false;
        }
        TravelOptions that = (TravelOptions)o;
        return Double.compare(that.bikeSpeed, this.bikeSpeed) == 0 && Double.compare(that.bikeUphill, this.bikeUphill) == 0 && Double.compare(that.bikeDownhill, this.bikeDownhill) == 0 && Double.compare(that.walkSpeed, this.walkSpeed) == 0 && Double.compare(that.walkUphill, this.walkUphill) == 0 && Double.compare(that.walkDownhill, this.walkDownhill) == 0 && Objects.equals(that.trafficJunctionPenalty, this.trafficJunctionPenalty) && Objects.equals(that.trafficSignalPenalty, this.trafficSignalPenalty) && this.onlyPrintReachablePoints == that.onlyPrintReachablePoints && Objects.equals(this.sources, that.sources) && Objects.equals(this.targets, that.targets) && Objects.equals(this.rushHour, that.rushHour) && Objects.equals(this.travelTimes, that.travelTimes) && this.travelType == that.travelType && Objects.equals(this.elevationEnabled, that.elevationEnabled) && Objects.equals(this.pointReduction, that.pointReduction) && Objects.equals(this.reverse, that.reverse) && Objects.equals(this.minPolygonHoleSize, that.minPolygonHoleSize) && Objects.equals(this.time, that.time) && Objects.equals(this.date, that.date) && Objects.equals(this.frame, that.frame) && Objects.equals(this.intersectionGeometry, that.intersectionGeometry) && Objects.equals(this.recommendations, that.recommendations) && Objects.equals(this.srid, that.srid) && Objects.equals(this.decimalPrecision, that.decimalPrecision) && Objects.equals(this.buffer, that.buffer) && Objects.equals(this.simplify, that.simplify) && this.intersectionMode == that.intersectionMode && this.pathSerializer == that.pathSerializer && this.polygonSerializerType == that.polygonSerializerType && Objects.equals(this.multiGraphEdgeClasses, that.multiGraphEdgeClasses) && this.multiGraphSerializationFormat == that.multiGraphSerializationFormat && Objects.equals(this.multiGraphSerializationDecimalPrecision, that.multiGraphSerializationDecimalPrecision) && Objects.equals(this.multiGraphSerializationMaxGeometryCount, that.multiGraphSerializationMaxGeometryCount) && this.multiGraphAggregationType == that.multiGraphAggregationType && Objects.equals(this.multiGraphAggregationIgnoreOutlier, that.multiGraphAggregationIgnoreOutlier) && Objects.equals(this.multiGraphAggregationOutlierPenalty, that.multiGraphAggregationOutlierPenalty) && Objects.equals(this.multiGraphAggregationMinSourcesRatio, that.multiGraphAggregationMinSourcesRatio) && Objects.equals(this.multiGraphAggregationMinSourcesCount, that.multiGraphAggregationMinSourcesCount) && Objects.equals(this.multiGraphAggregationMaxResultValueRatio, that.multiGraphAggregationMaxResultValueRatio) && Objects.equals(this.multiGraphAggregationMaxResultValue, that.multiGraphAggregationMaxResultValue) && Objects.equals(this.multiGraphAggregationFilterValuesForSourceOrigins, that.multiGraphAggregationFilterValuesForSourceOrigins) && this.multiGraphLayerType == that.multiGraphLayerType && this.multiGraphLayerEdgeAggregationType == that.multiGraphLayerEdgeAggregationType && Objects.equals(this.multiGraphLayerGeometryDetailPerTile, that.multiGraphLayerGeometryDetailPerTile) && Objects.equals(this.multiGraphLayerMinGeometryDetailLevel, that.multiGraphLayerMinGeometryDetailLevel) && Objects.equals(this.multiGraphLayerMaxGeometryDetailLevel, that.multiGraphLayerMaxGeometryDetailLevel) && Objects.equals(this.multiGraphLayerGeometryDetailLevel, that.multiGraphLayerGeometryDetailLevel) && Objects.equals(this.multiGraphTileZoom, that.multiGraphTileZoom) && Objects.equals(this.multiGraphTileX, that.multiGraphTileX) && Objects.equals(this.multiGraphTileY, that.multiGraphTileY) && Objects.equals(this.maxEdgeWeight, that.maxEdgeWeight) && Objects.equals(this.serviceUrl, that.serviceUrl) && Objects.equals(this.fallbackServiceUrl, that.fallbackServiceUrl) && Objects.equals(this.serviceKey, that.serviceKey) && this.edgeWeightType == that.edgeWeightType && Objects.equals(this.statisticIds, that.statisticIds) && Objects.equals(this.statisticGroupId, that.statisticGroupId) && Objects.equals(this.statisticServiceUrl, that.statisticServiceUrl) && Objects.equals(this.pointOfInterestServiceUrl, that.pointOfInterestServiceUrl) && Objects.equals(this.overpassQuery, that.overpassQuery) && Objects.equals(this.overpassServiceUrl, that.overpassServiceUrl) && Objects.equals(this.interServiceKey, that.interServiceKey) && this.format == that.format && Objects.equals(this.boundingBox, that.boundingBox) && Objects.equals(this.travelTypes, that.travelTypes) && Objects.equals(this.osmTypes, that.osmTypes) && Objects.equals(this.customPois, that.customPois) && Objects.equals(this.travelTimeFactors, that.travelTimeFactors) && Objects.equals(this.maxTransfers, that.maxTransfers) && Objects.equals(this.avoidTransitRouteTypes, that.avoidTransitRouteTypes) && Objects.equals(this.multiGraphPreAggregationPipeline, that.multiGraphPreAggregationPipeline) && Objects.equals(this.multiGraphSourceParameters, that.multiGraphSourceParameters) && Objects.equals(this.maxWalkingTimeFromSource, that.maxWalkingTimeFromSource) && Objects.equals(this.maxWalkingTimeToTarget, that.maxWalkingTimeToTarget);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sources, this.targets, this.bikeSpeed, this.bikeUphill, this.bikeDownhill, this.walkSpeed, this.walkUphill, this.walkDownhill, this.rushHour, this.travelTimes, this.travelType, this.elevationEnabled, this.appendTravelTimes, this.pointReduction, this.reverse, this.minPolygonHoleSize, this.time, this.date, this.frame, this.recommendations, this.srid, this.decimalPrecision, this.buffer, this.simplify, this.intersectionMode, this.pathSerializer, this.polygonSerializerType, this.intersectionGeometry, this.multiGraphEdgeClasses, this.multiGraphSerializationFormat, this.multiGraphSerializationDecimalPrecision, this.multiGraphSerializationMaxGeometryCount, this.multiGraphAggregationType, this.multiGraphAggregationIgnoreOutlier, this.multiGraphAggregationOutlierPenalty, this.multiGraphAggregationMinSourcesRatio, this.multiGraphAggregationMinSourcesCount, this.multiGraphAggregationMaxResultValueRatio, this.multiGraphAggregationMaxResultValue, this.multiGraphAggregationFilterValuesForSourceOrigins, this.multiGraphLayerType, this.multiGraphLayerEdgeAggregationType, this.multiGraphLayerGeometryDetailPerTile, this.multiGraphLayerMinGeometryDetailLevel, this.multiGraphLayerMaxGeometryDetailLevel, this.multiGraphLayerGeometryDetailLevel, this.multiGraphTileZoom, this.multiGraphTileX, this.multiGraphTileY, this.maxEdgeWeight, this.serviceUrl, this.fallbackServiceUrl, this.serviceKey, this.onlyPrintReachablePoints, this.edgeWeightType, this.statisticIds, this.statisticGroupId, this.statisticServiceUrl, this.pointOfInterestServiceUrl, this.overpassQuery, this.overpassServiceUrl, this.interServiceKey, this.format, this.boundingBox, this.travelTypes, this.osmTypes, this.customPois, this.travelTimeFactors, this.maxTransfers, this.avoidTransitRouteTypes, this.trafficJunctionPenalty, this.trafficSignalPenalty, this.multiGraphPreAggregationPipeline, this.multiGraphSourceParameters, this.maxWalkingTimeFromSource, this.maxWalkingTimeToTarget});
    }

    public String toString() {
        int maxLen = 5;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" {\n\tsources: ");
        builder.append(this.sources != null ? this.toString(this.sources.entrySet(), 5) : null);
        builder.append("\n\ttargets: ");
        builder.append(this.targets != null ? this.toString(this.targets.entrySet(), 5) : null);
        builder.append("\n\tbikeSpeed: ");
        builder.append(this.bikeSpeed);
        builder.append("\n\tbikeUphill: ");
        builder.append(this.bikeUphill);
        builder.append("\n\tbikeDownhill: ");
        builder.append(this.bikeDownhill);
        builder.append("\n\twalkSpeed: ");
        builder.append(this.walkSpeed);
        builder.append("\n\twalkUphill: ");
        builder.append(this.walkUphill);
        builder.append("\n\twalkDownhill: ");
        builder.append(this.walkDownhill);
        builder.append("\n\ttrafficJunctionPenalty: ");
        builder.append(this.trafficJunctionPenalty);
        builder.append("\n\ttrafficSignalPenalty: ");
        builder.append(this.trafficSignalPenalty);
        builder.append("\n\trushHour: ");
        builder.append(this.rushHour);
        builder.append("\n\ttravelTimes: ");
        builder.append(this.travelTimes != null ? this.toString(this.travelTimes, 5) : null);
        builder.append("\n\ttravelType: ");
        builder.append((Object)this.travelType);
        builder.append("\n\televationEnabled: ");
        builder.append(this.elevationEnabled);
        builder.append("\n\tappendTravelTimes: ");
        builder.append(this.appendTravelTimes);
        builder.append("\n\tpointReduction: ");
        builder.append(this.pointReduction);
        builder.append("\n\treverse: ");
        builder.append(this.reverse);
        builder.append("\n\tminPolygonHoleSize: ");
        builder.append(this.minPolygonHoleSize);
        builder.append("\n\ttime: ");
        builder.append(this.time);
        builder.append("\n\tdate: ");
        builder.append(this.date);
        builder.append("\n\tframe: ");
        builder.append(this.frame);
        builder.append("\n\trecommendations: ");
        builder.append(this.recommendations);
        builder.append("\n\tsrid: ");
        builder.append(this.srid);
        builder.append("\n\tdecimalPrecision: ");
        builder.append(this.decimalPrecision);
        builder.append("\n\tbuffer: ");
        builder.append(this.buffer);
        builder.append("\n\tsimplify: ");
        builder.append(this.simplify);
        builder.append("\n\tintersectionMode: ");
        builder.append((Object)this.intersectionMode);
        builder.append("\n\tpathSerializer: ");
        builder.append((Object)this.pathSerializer);
        builder.append("\n\tpolygonSerializerType: ");
        builder.append((Object)this.polygonSerializerType);
        builder.append("\n\tmultiGraphEdgeClasses: ");
        builder.append(this.multiGraphEdgeClasses);
        builder.append("\n\tmultiGraphSerializationFormat: ");
        builder.append((Object)this.multiGraphSerializationFormat);
        builder.append("\n\tmultiGraphSerializationDecimalPrecision: ");
        builder.append(this.multiGraphSerializationDecimalPrecision);
        builder.append("\n\tmultiGraphSerializationMaxGeometryCount: ");
        builder.append(this.multiGraphSerializationMaxGeometryCount);
        builder.append("\n\tmultiGraphAggregationType: ");
        builder.append((Object)this.multiGraphAggregationType);
        builder.append("\n\tmultiGraphAggregationIgnoreOutlier: ");
        builder.append(this.multiGraphAggregationIgnoreOutlier);
        builder.append("\n\tmultiGraphAggregationOutlierPenalty: ");
        builder.append(this.multiGraphAggregationOutlierPenalty);
        builder.append("\n\tmultiGraphAggregationMinSourcesRatio: ");
        builder.append(this.multiGraphAggregationMinSourcesRatio);
        builder.append("\n\tmultiGraphAggregationMinSourcesCount: ");
        builder.append(this.multiGraphAggregationMinSourcesCount);
        builder.append("\n\tmultiGraphAggregationMaxResultValueRatio: ");
        builder.append(this.multiGraphAggregationMaxResultValueRatio);
        builder.append("\n\tmultiGraphAggregationMaxResultValue: ");
        builder.append(this.multiGraphAggregationMaxResultValue);
        builder.append("\n\tmultiGraphAggregationFilterValuesForSourceOrigins: ");
        builder.append(this.multiGraphAggregationFilterValuesForSourceOrigins);
        builder.append("\n\tmultiGraphLayerType: ");
        builder.append((Object)this.multiGraphLayerType);
        builder.append("\n\tmultiGraphLayerEdgeAggregationType: ");
        builder.append((Object)this.multiGraphLayerEdgeAggregationType);
        builder.append("\n\tmultiGraphLayerGeometryDetailPerTile: ");
        builder.append(this.multiGraphLayerGeometryDetailPerTile);
        builder.append("\n\tmultiGraphLayerMinGeometryDetailLevel: ");
        builder.append(this.multiGraphLayerMinGeometryDetailLevel);
        builder.append("\n\tmultiGraphLayerMaxGeometryDetailLevel: ");
        builder.append(this.multiGraphLayerMaxGeometryDetailLevel);
        builder.append("\n\tmultiGraphLayerGeometryDetailLevel: ");
        builder.append(this.multiGraphLayerGeometryDetailLevel);
        builder.append("\n\tmultiGraphTileZoom: ");
        builder.append(this.multiGraphTileZoom);
        builder.append("\n\tmultiGraphTileX: ");
        builder.append(this.multiGraphTileX);
        builder.append("\n\tmultiGraphTileY: ");
        builder.append(this.multiGraphTileY);
        builder.append("\n\tmaxEdgeWeight: ");
        builder.append(this.maxEdgeWeight);
        builder.append("\n\tserviceUrl: ");
        builder.append(this.serviceUrl);
        builder.append("\n\tserviceKey: ");
        builder.append(this.fallbackServiceUrl);
        builder.append("\n\tfallbackServiceUrl: ");
        builder.append(this.serviceKey);
        builder.append("\n\tonlyPrintReachablePoints: ");
        builder.append(this.onlyPrintReachablePoints);
        builder.append("\n\tedgeWeightType: ");
        builder.append((Object)this.edgeWeightType);
        builder.append("\n\tstatisticIds: ");
        builder.append(this.statisticIds != null ? this.toString(this.statisticIds, 5) : null);
        builder.append("\n\tstatisticGroupId: ");
        builder.append(this.statisticGroupId);
        builder.append("\n\tstatisticServiceUrl: ");
        builder.append(this.statisticServiceUrl);
        builder.append("\n\tpointOfInterestServiceUrl: ");
        builder.append(this.pointOfInterestServiceUrl);
        builder.append("\n\toverpassQuery: ");
        builder.append(this.overpassQuery);
        builder.append("\n\toverpassServiceUrl: ");
        builder.append(this.overpassServiceUrl);
        builder.append("\n\tinterServiceKey: ");
        builder.append(this.interServiceKey);
        builder.append("\n\tformat: ");
        builder.append((Object)this.format);
        builder.append("\n\tboundingBox: ");
        builder.append(this.boundingBox);
        builder.append("\n\ttravelTypes: ");
        builder.append(this.travelTypes != null ? this.toString(this.travelTypes, 5) : null);
        builder.append("\n\tosmTypes: ");
        builder.append(this.osmTypes != null ? this.toString(this.osmTypes, 5) : null);
        builder.append("\n\tcustomPois: ");
        builder.append(this.customPois != null ? this.toString(this.customPois, 5) : null);
        builder.append("\n\ttravelTimeFactors: ");
        builder.append(this.travelTimeFactors != null ? this.toString(this.travelTimeFactors.entrySet(), 5) : null);
        builder.append("\n\tmaxTransfers: ");
        builder.append(this.maxTransfers);
        builder.append("\n\tavoidTransitRouteTypes: ");
        builder.append(this.avoidTransitRouteTypes != null ? this.toString(this.avoidTransitRouteTypes, 5) : null);
        builder.append("\n\tmaxWalkingTimeFromSource: ");
        builder.append(this.maxWalkingTimeFromSource);
        builder.append("\n\tmaxWalkingTimeToTarget: ");
        builder.append(this.maxWalkingTimeToTarget);
        builder.append("\n}\n");
        return builder.toString();
    }

    public Coordinate getSource(String id) {
        return this.sources.get(id);
    }

    public Coordinate getTarget(String id) {
        return this.targets.get(id);
    }

    public List<Short> getStatisticIds() {
        return this.statisticIds;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setOnlyPrintReachablePoints(boolean onlyPrintReachablePoints) {
        this.onlyPrintReachablePoints = onlyPrintReachablePoints;
    }

    public boolean getOnlyPrintReachablePoints() {
        return this.onlyPrintReachablePoints;
    }

    public void setStatisticIds(List<Short> statisticIds) {
        this.statisticIds = statisticIds;
    }

    public Double getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Double buffer) {
        this.buffer = buffer;
    }

    public Double getSimplify() {
        return this.simplify;
    }

    public void setSimplify(Double simplify) {
        this.simplify = simplify;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public Integer getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public void setDecimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public Boolean getAppendTravelTimes() {
        return this.appendTravelTimes;
    }

    public Set<Integer> getMultiGraphEdgeClasses() {
        return this.multiGraphEdgeClasses;
    }

    public void setMultiGraphEdgeClasses(Set<Integer> multiGraphEdgeClasses) {
        this.multiGraphEdgeClasses = multiGraphEdgeClasses;
    }

    public MultiGraphSerializationFormat getMultiGraphSerializationFormat() {
        return this.multiGraphSerializationFormat;
    }

    public void setMultiGraphSerializationFormat(MultiGraphSerializationFormat multiGraphSerializationFormat) {
        this.multiGraphSerializationFormat = multiGraphSerializationFormat;
    }

    public Integer getMultiGraphSerializationDecimalPrecision() {
        return this.multiGraphSerializationDecimalPrecision;
    }

    public void setMultiGraphSerializationDecimalPrecision(Integer multiGraphSerializationDecimalPrecision) {
        this.multiGraphSerializationDecimalPrecision = multiGraphSerializationDecimalPrecision;
    }

    public Integer getMultiGraphSerializationMaxGeometryCount() {
        return this.multiGraphSerializationMaxGeometryCount;
    }

    public void setMultiGraphSerializationMaxGeometryCount(Integer multiGraphSerializationMaxGeometryCount) {
        this.multiGraphSerializationMaxGeometryCount = multiGraphSerializationMaxGeometryCount;
    }

    public MultiGraphAggregationType getMultiGraphAggregationType() {
        return this.multiGraphAggregationType;
    }

    public void setMultiGraphAggregationType(MultiGraphAggregationType multiGraphAggregationType) {
        this.multiGraphAggregationType = multiGraphAggregationType;
    }

    public Boolean getMultiGraphAggregationIgnoreOutlier() {
        return this.multiGraphAggregationIgnoreOutlier;
    }

    public void setMultiGraphAggregationIgnoreOutlier(Boolean multiGraphAggregationIgnoreOutlier) {
        this.multiGraphAggregationIgnoreOutlier = multiGraphAggregationIgnoreOutlier;
    }

    public Integer getMultiGraphAggregationOutlierPenalty() {
        return this.multiGraphAggregationOutlierPenalty;
    }

    public void setMultiGraphAggregationOutlierPenalty(Integer multiGraphAggregationOutlierPenalty) {
        this.multiGraphAggregationOutlierPenalty = multiGraphAggregationOutlierPenalty;
    }

    public Double getMultiGraphAggregationMinSourcesRatio() {
        return this.multiGraphAggregationMinSourcesRatio;
    }

    public void setMultiGraphAggregationMinSourcesRatio(Double multiGraphAggregationMinSourcesRatio) {
        this.multiGraphAggregationMinSourcesRatio = multiGraphAggregationMinSourcesRatio;
    }

    public Integer getMultiGraphAggregationMinSourcesCount() {
        return this.multiGraphAggregationMinSourcesCount;
    }

    public void setMultiGraphAggregationMinSourcesCount(Integer multiGraphAggregationMinSourcesCount) {
        this.multiGraphAggregationMinSourcesCount = multiGraphAggregationMinSourcesCount;
    }

    public Double getMultiGraphAggregationMaxResultValueRatio() {
        return this.multiGraphAggregationMaxResultValueRatio;
    }

    public void setMultiGraphAggregationMaxResultValueRatio(Double multiGraphAggregationMaxResultValueRatio) {
        this.multiGraphAggregationMaxResultValueRatio = multiGraphAggregationMaxResultValueRatio;
    }

    public Integer getMultiGraphAggregationMaxResultValue() {
        return this.multiGraphAggregationMaxResultValue;
    }

    public void setMultiGraphAggregationMaxResultValue(Integer multiGraphAggregationMaxResultValue) {
        this.multiGraphAggregationMaxResultValue = multiGraphAggregationMaxResultValue;
    }

    public Set<String> getMultiGraphAggregationFilterValuesForSourceOrigins() {
        return this.multiGraphAggregationFilterValuesForSourceOrigins;
    }

    public void setMultiGraphAggregationFilterValuesForSourceOrigins(Set<String> multiGraphAggregationFilterValuesForSourceOrigins) {
        this.multiGraphAggregationFilterValuesForSourceOrigins = multiGraphAggregationFilterValuesForSourceOrigins;
    }

    public MultiGraphLayerType getMultiGraphLayerType() {
        return this.multiGraphLayerType;
    }

    public void setMultiGraphLayerType(MultiGraphLayerType multiGraphLayerType) {
        this.multiGraphLayerType = multiGraphLayerType;
    }

    public MultiGraphLayerEdgeAggregationType getMultiGraphLayerEdgeAggregationType() {
        return this.multiGraphLayerEdgeAggregationType;
    }

    public void setMultiGraphLayerEdgeAggregationType(MultiGraphLayerEdgeAggregationType multiGraphLayerEdgeAggregationType) {
        this.multiGraphLayerEdgeAggregationType = multiGraphLayerEdgeAggregationType;
    }

    public Integer getMultiGraphLayerGeometryDetailPerTile() {
        return this.multiGraphLayerGeometryDetailPerTile;
    }

    public void setMultiGraphLayerGeometryDetailPerTile(Integer multiGraphLayerGeometryDetailPerTile) {
        this.multiGraphLayerGeometryDetailPerTile = multiGraphLayerGeometryDetailPerTile;
    }

    public Integer getMultiGraphLayerMinGeometryDetailLevel() {
        return this.multiGraphLayerMinGeometryDetailLevel;
    }

    public void setMultiGraphLayerMinGeometryDetailLevel(Integer multiGraphLayerMinGeometryDetailLevel) {
        this.multiGraphLayerMinGeometryDetailLevel = multiGraphLayerMinGeometryDetailLevel;
    }

    public Integer getMultiGraphLayerMaxGeometryDetailLevel() {
        return this.multiGraphLayerMaxGeometryDetailLevel;
    }

    public void setMultiGraphLayerMaxGeometryDetailLevel(Integer multiGraphLayerMaxGeometryDetailLevel) {
        this.multiGraphLayerMaxGeometryDetailLevel = multiGraphLayerMaxGeometryDetailLevel;
    }

    public Integer getMultiGraphLayerGeometryDetailLevel() {
        return this.multiGraphLayerGeometryDetailLevel;
    }

    public void setMultiGraphLayerGeometryDetailLevel(Integer multiGraphLayerGeometryDetailLevel) {
        this.multiGraphLayerGeometryDetailLevel = multiGraphLayerGeometryDetailLevel;
    }

    public Integer getMultiGraphTileZoom() {
        return this.multiGraphTileZoom;
    }

    public void setMultiGraphTileZoom(Integer multiGraphTileZoom) {
        this.multiGraphTileZoom = multiGraphTileZoom;
    }

    public Integer getMultiGraphTileX() {
        return this.multiGraphTileX;
    }

    public void setMultiGraphTileX(Integer multiGraphTileX) {
        this.multiGraphTileX = multiGraphTileX;
    }

    public Integer getMultiGraphTileY() {
        return this.multiGraphTileY;
    }

    public void setMultiGraphTileY(Integer multiGraphTileY) {
        this.multiGraphTileY = multiGraphTileY;
    }

    public EdgeWeightType getEdgeWeightType() {
        return this.edgeWeightType;
    }

    public void setEdgeWeightType(EdgeWeightType edgeWeightType) {
        this.edgeWeightType = edgeWeightType;
    }

    public void setAppendTravelTimes(Boolean appendTravelTimes) {
        this.appendTravelTimes = appendTravelTimes;
    }

    public String getStatisticServiceUrl() {
        return this.statisticServiceUrl;
    }

    public void setStatisticServiceUrl(String statisticServiceUrl) {
        this.statisticServiceUrl = statisticServiceUrl;
    }

    public Integer getStatisticGroupId() {
        return this.statisticGroupId;
    }

    public void setStatisticGroupId(Integer statisticGroupId) {
        this.statisticGroupId = statisticGroupId;
    }

    public Integer getMaxEdgeWeight() {
        return this.maxEdgeWeight;
    }

    public void setMaxEdgeWeight(Integer maxEdgeWeight) {
        this.maxEdgeWeight = maxEdgeWeight;
    }

    public void addAllSources(Map<String, Coordinate> sources) {
        this.sources.putAll(sources);
    }

    public void clearAndAddSource(String id, Coordinate source) {
        this.sources.clear();
        this.sources.put(id, source);
    }

    public String getFallbackServiceUrl() {
        return this.fallbackServiceUrl;
    }

    public void setFallbackServiceUrl(String fallbackServiceUrl) {
        this.fallbackServiceUrl = fallbackServiceUrl;
    }

    public String getPointOfInterestServiceUrl() {
        return this.pointOfInterestServiceUrl;
    }

    public String getOverpassServiceUrl() {
        return this.overpassServiceUrl;
    }

    public void setOverpassServiceUrl(String overpassServiceUrl) {
        this.overpassServiceUrl = overpassServiceUrl;
    }

    public String getOverpassQuery() {
        return this.overpassQuery;
    }

    public void setOverpassQuery(String overpassQuery) {
        this.overpassQuery = overpassQuery;
    }

    public String getInterServiceKey() {
        return this.interServiceKey;
    }

    public void setInterServiceKey(String interServiceKey) {
        this.interServiceKey = interServiceKey;
    }

    public Integer getMaxTransfers() {
        return this.maxTransfers;
    }

    public void setMaxTransfers(Integer maxTransfers) {
        this.maxTransfers = maxTransfers;
    }

    public Map<String, Double> getTravelTimeFactors() {
        return this.travelTimeFactors;
    }

    public void setTravelTimeFactors(Map<String, Double> travelTimeFactors) {
        this.travelTimeFactors = travelTimeFactors;
    }

    public Geometry getIntersectionGeometry() {
        return this.intersectionGeometry;
    }

    public void setIntersectionGeometry(Geometry intersectionGeometry) {
        this.intersectionGeometry = intersectionGeometry;
    }

    public boolean isDisableCache() {
        return this.disableCache;
    }

    public void setDisableCache(boolean disableCache) {
        this.disableCache = disableCache;
    }

    public List<Integer> getAvoidTransitRouteTypes() {
        return this.avoidTransitRouteTypes;
    }

    public void setAvoidTransitRouteTypes(List<Integer> avoidTransitRouteTypes) {
        this.avoidTransitRouteTypes = avoidTransitRouteTypes;
    }
}

