/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.targomo.client.api.enums.PolygonIntersectionMode;
import java.util.stream.Stream;

public enum MultiGraphAggregationType {
    NONE("none", null),
    MINIMUM("min", null),
    MAXIMUM("max", null),
    SUM("sum", null),
    MEAN("mean", null),
    MEDIAN("median", null),
    NEAREST("nearest", null),
    ROUTING_UNION("routing_union", PolygonIntersectionMode.UNION);

    private final String key;
    private final PolygonIntersectionMode associatedRoutingAggregation;

    private MultiGraphAggregationType(String key, PolygonIntersectionMode associatedRoutingAggregation) {
        this.key = key;
        this.associatedRoutingAggregation = associatedRoutingAggregation;
    }

    @JsonCreator
    public static MultiGraphAggregationType fromString(String key) {
        return key == null ? null : Stream.of(MultiGraphAggregationType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + MultiGraphAggregationType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public PolygonIntersectionMode getAssociatedRoutingAggregation() {
        return this.associatedRoutingAggregation;
    }
}

