/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request.config.multigraph;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.targomo.client.api.enums.MultiGraphAggregationType;
import com.targomo.client.api.request.config.multigraph.SourceParameter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AggregationConfig {
    private MultiGraphAggregationType type;
    private Boolean ignoreOutlier;
    private Integer outlierPenalty;
    private Double minSourcesRatio;
    private Integer minSourcesCount;
    private Double maxResultValueRatio;
    private Integer maxResultValue;
    private Set<String> filterValuesForSourceOrigins;
    private Map<String, SourceParameter> sourceParameters = new LinkedHashMap<String, SourceParameter>();

    public AggregationConfig() {
    }

    @JsonCreator
    public AggregationConfig(@JsonProperty(value="type") MultiGraphAggregationType type, @JsonProperty(value="ignoreOutliers") Boolean ignoreOutlier, @JsonProperty(value="outlierPenalty") Integer outlierPenalty, @JsonProperty(value="minSourcesRatio") Double minSourcesRatio, @JsonProperty(value="minSourcesCount") Integer minSourcesCount, @JsonProperty(value="maxResultValueRatio") Double maxResultValueRatio, @JsonProperty(value="maxResultValue") Integer maxResultValue, @JsonProperty(value="sourceParameters") Map<String, SourceParameter> sourceParameters, @JsonProperty(value="filterValuesForSourceOrigins") Set<String> filterValuesForSourceOrigins) {
        this.type = type;
        this.ignoreOutlier = ignoreOutlier;
        this.outlierPenalty = outlierPenalty;
        this.minSourcesRatio = minSourcesRatio;
        this.minSourcesCount = minSourcesCount;
        this.maxResultValueRatio = maxResultValueRatio;
        this.maxResultValue = maxResultValue;
        this.sourceParameters = sourceParameters;
        this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
    }

    public static AggregationConfigBuilder builder() {
        return new AggregationConfigBuilder();
    }

    public MultiGraphAggregationType getType() {
        return this.type;
    }

    public void setType(MultiGraphAggregationType type) {
        this.type = type;
    }

    public Boolean isIgnoreOutlier() {
        return this.ignoreOutlier;
    }

    public Integer getOutlierPenalty() {
        return this.outlierPenalty;
    }

    public void setOutlierPenalty(Integer outlierPenalty) {
        this.outlierPenalty = outlierPenalty;
    }

    public Double getMinSourcesRatio() {
        return this.minSourcesRatio;
    }

    public void setMinSourcesRatio(Double minSourcesRatio) {
        this.minSourcesRatio = minSourcesRatio;
    }

    public Integer getMinSourcesCount() {
        return this.minSourcesCount;
    }

    public void setMinSourcesCount(Integer minSourcesCount) {
        this.minSourcesCount = minSourcesCount;
    }

    public Double getMaxResultValueRatio() {
        return this.maxResultValueRatio;
    }

    public void setMaxResultValueRatio(Double maxResultValueRatio) {
        this.maxResultValueRatio = maxResultValueRatio;
    }

    public Integer getMaxResultValue() {
        return this.maxResultValue;
    }

    public void setMaxResultValue(Integer maxResultValue) {
        this.maxResultValue = maxResultValue;
    }

    public Map<String, SourceParameter> getSourceParameters() {
        return this.sourceParameters;
    }

    public void setSourceParameters(Map<String, SourceParameter> sourceParameters) {
        this.sourceParameters = sourceParameters;
    }

    public void setIgnoreOutlier(Boolean ignoreOutlier) {
        this.ignoreOutlier = ignoreOutlier;
    }

    public Set<String> getFilterValuesForSourceOrigins() {
        return this.filterValuesForSourceOrigins;
    }

    public void setFilterValuesForSourceOrigins(Set<String> filterValuesForSourceOrigins) {
        this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationConfig that = (AggregationConfig)o;
        return new EqualsBuilder().append((Object)this.ignoreOutlier, (Object)that.ignoreOutlier).append((Object)this.minSourcesCount, (Object)that.minSourcesCount).append((Object)this.type, (Object)that.type).append((Object)this.outlierPenalty, (Object)that.outlierPenalty).append((Object)this.minSourcesRatio, (Object)that.minSourcesRatio).append((Object)this.maxResultValueRatio, (Object)that.maxResultValueRatio).append((Object)this.maxResultValue, (Object)that.maxResultValue).append(this.filterValuesForSourceOrigins, that.filterValuesForSourceOrigins).append(this.sourceParameters, that.sourceParameters).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.type).append((Object)this.ignoreOutlier).append((Object)this.outlierPenalty).append((Object)this.minSourcesRatio).append((Object)this.minSourcesCount).append((Object)this.maxResultValueRatio).append((Object)this.maxResultValue).append(this.filterValuesForSourceOrigins).append(this.sourceParameters).toHashCode();
    }

    public String toString() {
        return "AggregationConfig{type=" + (Object)((Object)this.type) + ", ignoreOutlier=" + this.ignoreOutlier + ", outlierPenalty=" + this.outlierPenalty + ", minSourcesRatio=" + this.minSourcesRatio + ", minSourcesCount=" + this.minSourcesCount + ", maxResultValueRatio=" + this.maxResultValueRatio + ", maxResultValue=" + this.maxResultValue + ", filterValuesForSourceOrigins=" + this.filterValuesForSourceOrigins + ", sourceParameters=" + this.sourceParameters + '}';
    }

    public static final class AggregationConfigBuilder {
        private MultiGraphAggregationType type;
        private Boolean ignoreOutlier;
        private Integer outlierPenalty;
        private Double minSourcesRatio;
        private Integer minSourcesCount;
        private Double maxResultValueRatio;
        private Integer maxResultValue;
        private Set<String> filterValuesForSourceOrigins;
        private Map<String, SourceParameter> sourceParameters = new LinkedHashMap<String, SourceParameter>();

        private AggregationConfigBuilder() {
        }

        public AggregationConfigBuilder type(MultiGraphAggregationType type) {
            this.type = type;
            return this;
        }

        public AggregationConfigBuilder ignoreOutlier(Boolean ignoreOutlier) {
            this.ignoreOutlier = ignoreOutlier;
            return this;
        }

        public AggregationConfigBuilder outlierPenalty(Integer outlierPenalty) {
            this.outlierPenalty = outlierPenalty;
            return this;
        }

        public AggregationConfigBuilder minSourcesRatio(Double minSourcesRatio) {
            this.minSourcesRatio = minSourcesRatio;
            return this;
        }

        public AggregationConfigBuilder minSourcesCount(Integer minSourcesCount) {
            this.minSourcesCount = minSourcesCount;
            return this;
        }

        public AggregationConfigBuilder maxResultValueRatio(Double maxResultValueRatio) {
            this.maxResultValueRatio = maxResultValueRatio;
            return this;
        }

        public AggregationConfigBuilder maxResultValue(Integer maxResultValue) {
            this.maxResultValue = maxResultValue;
            return this;
        }

        public AggregationConfigBuilder filterValuesForSourceOrigins(Set<String> filterValuesForSourceOrigins) {
            this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
            return this;
        }

        public AggregationConfigBuilder sourceParameters(Map<String, SourceParameter> sourceParameters) {
            this.sourceParameters = sourceParameters;
            return this;
        }

        public AggregationConfig build() {
            return new AggregationConfig(this.type, this.ignoreOutlier, this.outlierPenalty, this.minSourcesRatio, this.minSourcesCount, this.maxResultValueRatio, this.maxResultValue, this.sourceParameters, this.filterValuesForSourceOrigins);
        }
    }
}

