/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.targomo.client.api.enums.PolygonIntersectionMode;
import java.util.stream.Stream;

public enum MultiGraphAggregationType {
    ONE("one", false, null),
    MINIMUM("min", false, null),
    MAXIMUM("max", false, null),
    SUM("sum", false, null),
    MEAN("mean", false, null),
    MEDIAN("median", false, null),
    NEAREST("nearest", false, null),
    ROUTING_UNION("routing_union", false, PolygonIntersectionMode.UNION),
    GRAVITATION_HUFF("gravitation_huff", true, null),
    MATH("math", false, null);

    private final String key;
    private final PolygonIntersectionMode associatedRoutingAggregation;
    private final boolean requiresGravitationParameters;

    private MultiGraphAggregationType(String key, boolean requiresGravitationParameters, PolygonIntersectionMode associatedRoutingAggregation) {
        this.key = key;
        this.associatedRoutingAggregation = associatedRoutingAggregation;
        this.requiresGravitationParameters = requiresGravitationParameters;
    }

    @JsonCreator
    public static MultiGraphAggregationType fromString(String key) {
        return key == null ? null : Stream.of(MultiGraphAggregationType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + MultiGraphAggregationType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public PolygonIntersectionMode getAssociatedRoutingAggregation() {
        return this.associatedRoutingAggregation;
    }

    @JsonIgnore
    public boolean getRequiresGravitationParameters() {
        return this.requiresGravitationParameters;
    }
}

