/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum MultiGraphLayerType {
    NODE("node", false, false, false),
    EDGE("edge", true, false, false),
    TILE("tile", true, true, false),
    TILE_NODE("tile_node", false, true, false),
    HEXAGON("hexagon", true, true, false),
    HEXAGON_NODE("hexagon_node", false, true, false),
    GEOMETRY_STATISTICS("geometry_statistics", false, false, true),
    TILE_STATISTICS("tile_statistics", false, true, true);

    private String key;
    private boolean withEdges;
    private boolean geometryMerge;
    private boolean basedOnStatistics;

    private MultiGraphLayerType(String key, boolean withEdges, boolean geometryMerge, boolean basedOnStatistics) {
        this.key = key;
        this.withEdges = withEdges;
        this.geometryMerge = geometryMerge;
        this.basedOnStatistics = basedOnStatistics;
    }

    @JsonCreator
    public static MultiGraphLayerType fromString(String key) {
        return key == null ? null : Stream.of(MultiGraphLayerType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + MultiGraphLayerType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public boolean isWithEdges() {
        return this.withEdges;
    }

    @JsonIgnore
    public boolean isGeometryMerge() {
        return this.geometryMerge;
    }

    @JsonIgnore
    public boolean isBasedOnStatistics() {
        return this.basedOnStatistics;
    }
}

