/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.geo;

import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.Coordinate;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class AbstractCoordinate
implements Coordinate {
    private String id;
    private double x;
    private double y;

    public AbstractCoordinate() {
    }

    public AbstractCoordinate(String id, double x, double y) {
        this.id = id;
        this.x = x;
        this.y = y;
    }

    @Override
    public abstract TravelType getTravelType();

    @Override
    public abstract void setTravelType(TravelType var1);

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double y) {
        this.y = y;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" {\n\tid: ");
        builder.append(this.id);
        builder.append("\n\tx: ");
        builder.append(this.x);
        builder.append("\n\ty: ");
        builder.append(this.y);
        builder.append("\n}\n");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCoordinate that = (AbstractCoordinate)o;
        if (Double.compare(that.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(that.y, this.y) != 0) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

