/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.pojo;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.MultiGraphAggregationType;
import com.targomo.client.api.pojo.AggregationInputParameters;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AggregationConfiguration {
    private MultiGraphAggregationType type;
    private Boolean ignoreOutlier;
    private Float outlierPenalty;
    private Double minSourcesRatio;
    private Integer minSourcesCount;
    private Double maxResultValueRatio;
    private Float maxResultValue;
    private Float postAggregationFactor;
    private Set<String> filterValuesForSourceOrigins;
    private Double gravitationExponent;
    private Map<String, AggregationInputParameters> aggregationInputParameters;
    private String mathExpression;

    public MultiGraphAggregationType getType() {
        return this.type;
    }

    public Boolean getIgnoreOutlier() {
        return this.ignoreOutlier;
    }

    public Float getOutlierPenalty() {
        return this.outlierPenalty;
    }

    public Double getMinSourcesRatio() {
        return this.minSourcesRatio;
    }

    public Integer getMinSourcesCount() {
        return this.minSourcesCount;
    }

    public Double getMaxResultValueRatio() {
        return this.maxResultValueRatio;
    }

    public Float getMaxResultValue() {
        return this.maxResultValue;
    }

    public Float getPostAggregationFactor() {
        return this.postAggregationFactor;
    }

    public Set<String> getFilterValuesForSourceOrigins() {
        return this.filterValuesForSourceOrigins;
    }

    public Double getGravitationExponent() {
        return this.gravitationExponent;
    }

    public Map<String, AggregationInputParameters> getAggregationInputParameters() {
        return this.aggregationInputParameters;
    }

    public String getMathExpression() {
        return this.mathExpression;
    }

    public void setType(MultiGraphAggregationType type) {
        this.type = type;
    }

    public void setIgnoreOutlier(Boolean ignoreOutlier) {
        this.ignoreOutlier = ignoreOutlier;
    }

    public void setOutlierPenalty(Float outlierPenalty) {
        this.outlierPenalty = outlierPenalty;
    }

    public void setMinSourcesRatio(Double minSourcesRatio) {
        this.minSourcesRatio = minSourcesRatio;
    }

    public void setMinSourcesCount(Integer minSourcesCount) {
        this.minSourcesCount = minSourcesCount;
    }

    public void setMaxResultValueRatio(Double maxResultValueRatio) {
        this.maxResultValueRatio = maxResultValueRatio;
    }

    public void setMaxResultValue(Float maxResultValue) {
        this.maxResultValue = maxResultValue;
    }

    public void setPostAggregationFactor(Float postAggregationFactor) {
        this.postAggregationFactor = postAggregationFactor;
    }

    public void setFilterValuesForSourceOrigins(Set<String> filterValuesForSourceOrigins) {
        this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
    }

    public void setGravitationExponent(Double gravitationExponent) {
        this.gravitationExponent = gravitationExponent;
    }

    public void setAggregationInputParameters(Map<String, AggregationInputParameters> aggregationInputParameters) {
        this.aggregationInputParameters = aggregationInputParameters;
    }

    public void setMathExpression(String mathExpression) {
        this.mathExpression = mathExpression;
    }

    public AggregationConfiguration(MultiGraphAggregationType type, Boolean ignoreOutlier, Float outlierPenalty, Double minSourcesRatio, Integer minSourcesCount, Double maxResultValueRatio, Float maxResultValue, Float postAggregationFactor, Set<String> filterValuesForSourceOrigins, Double gravitationExponent, Map<String, AggregationInputParameters> aggregationInputParameters, String mathExpression) {
        this.type = type;
        this.ignoreOutlier = ignoreOutlier;
        this.outlierPenalty = outlierPenalty;
        this.minSourcesRatio = minSourcesRatio;
        this.minSourcesCount = minSourcesCount;
        this.maxResultValueRatio = maxResultValueRatio;
        this.maxResultValue = maxResultValue;
        this.postAggregationFactor = postAggregationFactor;
        this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
        this.gravitationExponent = gravitationExponent;
        this.aggregationInputParameters = aggregationInputParameters;
        this.mathExpression = mathExpression;
    }

    public AggregationConfiguration() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationConfiguration)) {
            return false;
        }
        AggregationConfiguration other = (AggregationConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MultiGraphAggregationType this$type = this.getType();
        MultiGraphAggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Boolean this$ignoreOutlier = this.getIgnoreOutlier();
        Boolean other$ignoreOutlier = other.getIgnoreOutlier();
        if (this$ignoreOutlier == null ? other$ignoreOutlier != null : !((Object)this$ignoreOutlier).equals(other$ignoreOutlier)) {
            return false;
        }
        Float this$outlierPenalty = this.getOutlierPenalty();
        Float other$outlierPenalty = other.getOutlierPenalty();
        if (this$outlierPenalty == null ? other$outlierPenalty != null : !((Object)this$outlierPenalty).equals(other$outlierPenalty)) {
            return false;
        }
        Double this$minSourcesRatio = this.getMinSourcesRatio();
        Double other$minSourcesRatio = other.getMinSourcesRatio();
        if (this$minSourcesRatio == null ? other$minSourcesRatio != null : !((Object)this$minSourcesRatio).equals(other$minSourcesRatio)) {
            return false;
        }
        Integer this$minSourcesCount = this.getMinSourcesCount();
        Integer other$minSourcesCount = other.getMinSourcesCount();
        if (this$minSourcesCount == null ? other$minSourcesCount != null : !((Object)this$minSourcesCount).equals(other$minSourcesCount)) {
            return false;
        }
        Double this$maxResultValueRatio = this.getMaxResultValueRatio();
        Double other$maxResultValueRatio = other.getMaxResultValueRatio();
        if (this$maxResultValueRatio == null ? other$maxResultValueRatio != null : !((Object)this$maxResultValueRatio).equals(other$maxResultValueRatio)) {
            return false;
        }
        Float this$maxResultValue = this.getMaxResultValue();
        Float other$maxResultValue = other.getMaxResultValue();
        if (this$maxResultValue == null ? other$maxResultValue != null : !((Object)this$maxResultValue).equals(other$maxResultValue)) {
            return false;
        }
        Float this$postAggregationFactor = this.getPostAggregationFactor();
        Float other$postAggregationFactor = other.getPostAggregationFactor();
        if (this$postAggregationFactor == null ? other$postAggregationFactor != null : !((Object)this$postAggregationFactor).equals(other$postAggregationFactor)) {
            return false;
        }
        Set<String> this$filterValuesForSourceOrigins = this.getFilterValuesForSourceOrigins();
        Set<String> other$filterValuesForSourceOrigins = other.getFilterValuesForSourceOrigins();
        if (this$filterValuesForSourceOrigins == null ? other$filterValuesForSourceOrigins != null : !((Object)this$filterValuesForSourceOrigins).equals(other$filterValuesForSourceOrigins)) {
            return false;
        }
        Double this$gravitationExponent = this.getGravitationExponent();
        Double other$gravitationExponent = other.getGravitationExponent();
        if (this$gravitationExponent == null ? other$gravitationExponent != null : !((Object)this$gravitationExponent).equals(other$gravitationExponent)) {
            return false;
        }
        Map<String, AggregationInputParameters> this$aggregationInputParameters = this.getAggregationInputParameters();
        Map<String, AggregationInputParameters> other$aggregationInputParameters = other.getAggregationInputParameters();
        if (this$aggregationInputParameters == null ? other$aggregationInputParameters != null : !((Object)this$aggregationInputParameters).equals(other$aggregationInputParameters)) {
            return false;
        }
        String this$mathExpression = this.getMathExpression();
        String other$mathExpression = other.getMathExpression();
        return !(this$mathExpression == null ? other$mathExpression != null : !this$mathExpression.equals(other$mathExpression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregationConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MultiGraphAggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Boolean $ignoreOutlier = this.getIgnoreOutlier();
        result = result * 59 + ($ignoreOutlier == null ? 43 : ((Object)$ignoreOutlier).hashCode());
        Float $outlierPenalty = this.getOutlierPenalty();
        result = result * 59 + ($outlierPenalty == null ? 43 : ((Object)$outlierPenalty).hashCode());
        Double $minSourcesRatio = this.getMinSourcesRatio();
        result = result * 59 + ($minSourcesRatio == null ? 43 : ((Object)$minSourcesRatio).hashCode());
        Integer $minSourcesCount = this.getMinSourcesCount();
        result = result * 59 + ($minSourcesCount == null ? 43 : ((Object)$minSourcesCount).hashCode());
        Double $maxResultValueRatio = this.getMaxResultValueRatio();
        result = result * 59 + ($maxResultValueRatio == null ? 43 : ((Object)$maxResultValueRatio).hashCode());
        Float $maxResultValue = this.getMaxResultValue();
        result = result * 59 + ($maxResultValue == null ? 43 : ((Object)$maxResultValue).hashCode());
        Float $postAggregationFactor = this.getPostAggregationFactor();
        result = result * 59 + ($postAggregationFactor == null ? 43 : ((Object)$postAggregationFactor).hashCode());
        Set<String> $filterValuesForSourceOrigins = this.getFilterValuesForSourceOrigins();
        result = result * 59 + ($filterValuesForSourceOrigins == null ? 43 : ((Object)$filterValuesForSourceOrigins).hashCode());
        Double $gravitationExponent = this.getGravitationExponent();
        result = result * 59 + ($gravitationExponent == null ? 43 : ((Object)$gravitationExponent).hashCode());
        Map<String, AggregationInputParameters> $aggregationInputParameters = this.getAggregationInputParameters();
        result = result * 59 + ($aggregationInputParameters == null ? 43 : ((Object)$aggregationInputParameters).hashCode());
        String $mathExpression = this.getMathExpression();
        result = result * 59 + ($mathExpression == null ? 43 : $mathExpression.hashCode());
        return result;
    }

    public String toString() {
        return "AggregationConfiguration(type=" + (Object)((Object)this.getType()) + ", ignoreOutlier=" + this.getIgnoreOutlier() + ", outlierPenalty=" + this.getOutlierPenalty() + ", minSourcesRatio=" + this.getMinSourcesRatio() + ", minSourcesCount=" + this.getMinSourcesCount() + ", maxResultValueRatio=" + this.getMaxResultValueRatio() + ", maxResultValue=" + this.getMaxResultValue() + ", postAggregationFactor=" + this.getPostAggregationFactor() + ", filterValuesForSourceOrigins=" + this.getFilterValuesForSourceOrigins() + ", gravitationExponent=" + this.getGravitationExponent() + ", aggregationInputParameters=" + this.getAggregationInputParameters() + ", mathExpression=" + this.getMathExpression() + ")";
    }

    public static class AggregationConfigurationBuilder {
        private MultiGraphAggregationType type;
        private Boolean ignoreOutlier;
        private Float outlierPenalty;
        private Double minSourcesRatio;
        private Integer minSourcesCount;
        private Double maxResultValueRatio;
        private Float maxResultValue;
        private Double gravitationExponent;
        private Float postAggregationFactor;
        private Set<String> filterValuesForSourceOrigins;
        private Map<String, AggregationInputParameters> aggregationInputParameters;
        private String mathExpression;

        public AggregationConfigurationBuilder() {
        }

        public AggregationConfigurationBuilder(AggregationConfiguration toCopy) {
            this.type = toCopy.type;
            this.ignoreOutlier = toCopy.ignoreOutlier;
            this.outlierPenalty = toCopy.outlierPenalty;
            this.minSourcesRatio = toCopy.minSourcesRatio;
            this.minSourcesCount = toCopy.minSourcesCount;
            this.maxResultValueRatio = toCopy.maxResultValueRatio;
            this.maxResultValue = toCopy.maxResultValue;
            this.filterValuesForSourceOrigins = Optional.ofNullable(toCopy.filterValuesForSourceOrigins).map(HashSet::new).orElse(null);
            this.gravitationExponent = toCopy.gravitationExponent;
            this.postAggregationFactor = toCopy.postAggregationFactor;
            this.aggregationInputParameters = Optional.ofNullable(toCopy.aggregationInputParameters).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AggregationInputParameters(((AggregationInputParameters)entry.getValue()).getInputFactor(), ((AggregationInputParameters)entry.getValue()).getGravitationPositiveInfluence(), ((AggregationInputParameters)entry.getValue()).getGravitationAttractionStrength())))).orElse(null);
            this.mathExpression = toCopy.mathExpression;
        }

        public AggregationConfigurationBuilder(TravelOptions travelOptions) {
            this.type = travelOptions.getMultiGraphAggregationType();
            this.ignoreOutlier = Optional.ofNullable(travelOptions.getMultiGraphAggregationIgnoreOutlier()).orElse(false);
            this.outlierPenalty = travelOptions.getMultiGraphAggregationOutlierPenalty();
            this.minSourcesRatio = travelOptions.getMultiGraphAggregationMinSourcesRatio();
            this.minSourcesCount = Optional.ofNullable(travelOptions.getMultiGraphAggregationMinSourcesCount()).orElse(1);
            this.maxResultValueRatio = travelOptions.getMultiGraphAggregationMaxResultValueRatio();
            this.maxResultValue = travelOptions.getMultiGraphAggregationMaxResultValue();
            this.postAggregationFactor = travelOptions.getMultiGraphAggregationPostAggregationFactor();
            this.filterValuesForSourceOrigins = Optional.ofNullable(travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins()).map(HashSet::new).orElse(null);
            this.gravitationExponent = travelOptions.getMultiGraphAggregationGravitationExponent();
            this.aggregationInputParameters = Optional.ofNullable(travelOptions.getMultiGraphAggregationInputParameters()).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AggregationInputParameters(((AggregationInputParameters)entry.getValue()).getInputFactor(), ((AggregationInputParameters)entry.getValue()).getGravitationPositiveInfluence(), ((AggregationInputParameters)entry.getValue()).getGravitationAttractionStrength())))).orElse(null);
        }

        public AggregationConfigurationBuilder type(MultiGraphAggregationType type) {
            this.type = type;
            return this;
        }

        public AggregationConfigurationBuilder ignoreOutlier(Boolean ignoreOutlier) {
            this.ignoreOutlier = ignoreOutlier;
            return this;
        }

        public AggregationConfigurationBuilder outlierPenalty(Float outlierPenalty) {
            this.outlierPenalty = outlierPenalty;
            return this;
        }

        public AggregationConfigurationBuilder minSourcesRatio(Double minSourcesRatio) {
            this.minSourcesRatio = minSourcesRatio;
            return this;
        }

        public AggregationConfigurationBuilder minSourcesCount(Integer minSourcesCount) {
            this.minSourcesCount = minSourcesCount;
            return this;
        }

        public AggregationConfigurationBuilder maxResultValueRatio(Double maxResultValueRatio) {
            this.maxResultValueRatio = maxResultValueRatio;
            return this;
        }

        public AggregationConfigurationBuilder maxResultValue(Float maxResultValue) {
            this.maxResultValue = maxResultValue;
            return this;
        }

        public AggregationConfigurationBuilder filterValuesForSourceOrigins(Set<String> filterValuesForSourceOrigins) {
            this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
            return this;
        }

        public AggregationConfigurationBuilder gravitationExponent(Double gravitationTravelTimeExponent) {
            this.gravitationExponent = gravitationTravelTimeExponent;
            return this;
        }

        public AggregationConfigurationBuilder aggregationInputParameters(Map<String, AggregationInputParameters> aggregationInputParameters) {
            this.aggregationInputParameters = aggregationInputParameters;
            return this;
        }

        public AggregationConfigurationBuilder postAggregationFactor(Float postAggregationFactor) {
            this.postAggregationFactor = postAggregationFactor;
            return this;
        }

        public AggregationConfigurationBuilder mathExpression(String mathExpression) {
            this.mathExpression = mathExpression;
            return this;
        }

        public AggregationConfiguration build() {
            return new AggregationConfiguration(this.type, this.ignoreOutlier, this.outlierPenalty, this.minSourcesRatio, this.minSourcesCount, this.maxResultValueRatio, this.maxResultValue, this.postAggregationFactor, this.filterValuesForSourceOrigins, this.gravitationExponent, this.aggregationInputParameters, this.mathExpression);
        }
    }
}

