/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.Format;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.util.JsonUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PointOfInterestResponse {
    private final TravelOptions travelOptions;
    private final JSONObject result;
    private final long requestEnd;
    private final Map<String, Integer> edgeWeights;

    public PointOfInterestResponse(TravelOptions travelOptions, JSONObject result, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestEnd = System.currentTimeMillis() - requestStart;
        this.result = result;
        this.edgeWeights = new HashMap<String, Integer>();
        this.mapResults();
    }

    public void mapResults() {
        if (Format.GEOJSON.equals((Object)this.travelOptions.getFormat())) {
            JSONArray jsonArray = JsonUtil.getJsonArray(this.result, "features");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject target = JsonUtil.getJSONObject(jsonArray, i);
                JSONObject properties = JsonUtil.getJSONObject(target, "properties");
                String trgId = JsonUtil.getString(properties, "id");
                this.addEdgeWeight(trgId, JsonUtil.getInt(properties, "edgeWeight"));
            }
        } else if (Format.JSON.equals((Object)this.travelOptions.getFormat())) {
            Iterator keysIterator = this.result.keys();
            while (keysIterator.hasNext()) {
                JSONObject obj = JsonUtil.getJSONObject(this.result, (String)keysIterator.next());
                this.addEdgeWeight(JsonUtil.getString(obj, "id"), JsonUtil.getInt(obj, "edgeWeight"));
            }
        } else {
            throw new TargomoClientRuntimeException("Unknown format given: " + (Object)((Object)this.travelOptions.getFormat()));
        }
    }

    public void addEdgeWeight(String targetId, Integer travelTime) {
        this.edgeWeights.put(targetId, travelTime);
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public Map<String, Integer> getEdgeWeights() {
        return this.edgeWeights;
    }

    public JSONObject getResult() {
        return this.result;
    }
}

